/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import java.util.Map;
import net.mehvahdjukaar.amendments.common.network.ClientBoundPlaySplashParticlesMessage;
import net.mehvahdjukaar.amendments.common.network.ModNetwork;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class ModCauldronBlock
extends AbstractCauldronBlock
implements EntityBlock {
    public ModCauldronBlock(BlockBehaviour.Properties properties) {
        super(properties, Map.of());
    }

    public Item m_5456_() {
        return Items.f_42544_;
    }

    public abstract IntegerProperty getLevelProperty();

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)this.getLevelProperty());
    }

    public void m_141997_(BlockState state, Level level, BlockPos pos, Biome.Precipitation precipitation) {
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LiquidCauldronBlockTile(pos, state);
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (this.m_151979_(state, pos, entity)) {
            if (!level.f_46443_) {
                ModCauldronBlock.playSplashEffects(entity, this.m_142446_(state));
            }
            super.m_142072_(level, state, pos, entity, 0.0f);
        } else {
            super.m_142072_(level, state, pos, entity, fallDistance);
        }
    }

    public static void playExtinguishSound(Level level, BlockPos pos, Entity entity) {
        level.m_5594_(null, pos, SoundEvents.f_11914_, entity.m_5720_(), 0.7f, 1.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.4f);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (this.m_151979_(state, pos, entity)) {
            entity.f_19798_ = true;
            if (level.f_46443_) {
                return;
            }
            if (entity.m_6060_()) {
                BlockEntity blockEntity;
                entity.m_20095_();
                ModCauldronBlock.playExtinguishSound(level, pos, entity);
                if (entity.m_142265_(level, pos) && (blockEntity = level.m_7702_(pos)) instanceof LiquidCauldronBlockTile) {
                    LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
                    te.consumeOneLayer();
                    level.m_142346_(entity, GameEvent.f_157792_, pos);
                }
            }
            this.handleEntityInside(state, level, pos, entity);
        }
    }

    protected abstract void handleEntityInside(BlockState var1, Level var2, BlockPos var3, Entity var4);

    public boolean doCraftItem(Level level, BlockPos pos, Player player, InteractionHand hand, SoftFluidStack fluid, ItemStack itemStack, ItemStack crafted, float layerPerItem, int itemCountMultiplier) {
        int maxRecolorable = (int)((float)(crafted.m_41613_() * itemCountMultiplier * fluid.getCount()) / layerPerItem);
        int amountToRecolor = Math.min(maxRecolorable, itemStack.m_41613_());
        if (amountToRecolor <= 0) {
            return false;
        }
        crafted.m_41764_(amountToRecolor);
        level.m_5594_(player, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.3f);
        if (!(player instanceof ServerPlayer)) {
            return true;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        player.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
        CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, itemStack);
        if (!player.m_7500_()) {
            itemStack.m_41774_(amountToRecolor);
            fluid.shrink(Mth.m_14167_((float)(layerPerItem * (float)amountToRecolor / (float)itemCountMultiplier)));
        }
        if (itemStack.m_41619_()) {
            player.m_21008_(hand, crafted);
        } else if (!player.m_150109_().m_36054_(crafted)) {
            player.m_36176_(crafted, false);
        }
        return true;
    }

    public abstract BlockState updateStateOnFluidChange(BlockState var1, Level var2, BlockPos var3, SoftFluidStack var4);

    public static void addSurfaceParticles(ParticleOptions type, Level level, BlockPos pos, int count, double surface, RandomSource rand, float r, float g, float b) {
        for (int i = 0; i < count; ++i) {
            double x = (double)pos.m_123341_() + 0.1875 + (double)rand.m_188501_() * 0.625;
            double y = (double)pos.m_123342_() + surface;
            double z = (double)pos.m_123343_() + 0.1875 + (double)rand.m_188501_() * 0.625;
            level.m_7106_(type, x, y, z, (double)r, (double)g, (double)b);
        }
    }

    public static void playSplashEffects(Entity entity, double waterHeight) {
        entity.m_146850_(GameEvent.f_157784_);
        Level level = entity.m_9236_();
        Entity feetEntity = entity.m_20160_() && entity.m_6688_() != null ? entity.m_6688_() : entity;
        float offset = feetEntity == entity ? 0.2f : 0.9f;
        Vec3 movement = feetEntity.m_20184_();
        float speed = Math.min(1.0f, (float)Math.sqrt(movement.f_82479_ * movement.f_82479_ * 0.2 + movement.f_82480_ * movement.f_82480_ + movement.f_82481_ * movement.f_82481_ * 0.2) * offset);
        BlockPos pos = BlockPos.m_274446_((Position)entity.m_20182_());
        Vec3 hitPos = new Vec3(entity.m_20185_(), (double)pos.m_123342_() + waterHeight, entity.m_20189_());
        RandomSource rand = level.f_46441_;
        if (speed < 0.25f) {
            level.m_6263_(null, hitPos.m_7096_(), hitPos.m_7098_(), hitPos.m_7094_(), entity.m_5509_(), entity.m_5720_(), speed, 1.0f + (rand.m_188501_() - rand.m_188501_()) * 0.4f);
        } else {
            level.m_6263_(null, hitPos.m_7096_(), hitPos.m_7098_(), hitPos.m_7094_(), entity.m_5508_(), entity.m_5720_(), speed, 1.0f + (rand.m_188501_() - rand.m_188501_()) * 0.4f);
        }
        ClientBoundPlaySplashParticlesMessage particlePacket = new ClientBoundPlaySplashParticlesMessage(hitPos, speed, feetEntity.m_20205_());
        ModNetwork.CHANNEL.sentToAllClientPlayersTrackingEntityAndSelf(entity, (Message)particlePacket);
    }
}

