/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.blocks.prism;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.advancement.ANCriteriaTriggers;
import com.hollingsworth.arsnouveau.common.block.SpellPrismBlock;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SpellMirror
extends SpellPrismBlock {
    static final VoxelShape base = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    static final VoxelShape south = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    static final VoxelShape floor = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    static final VoxelShape ceiling = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    static final VoxelShape east = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    static final VoxelShape west = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public SpellMirror(BlockBehaviour.Properties properties) {
        super(properties.m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        BlockState blockstate = pLevel.m_8055_(pPos.m_121945_(direction.m_122424_()));
        return blockstate.m_60783_((BlockGetter)pLevel, pPos, direction);
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        return pDirection == ((Direction)pState.m_61143_((Property)FACING)).m_122424_() && !this.m_7898_(pState, (LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    public void onHit(ServerLevel world, BlockPos pos, EntityProjectileSpell spell) {
        Direction direction = (Direction)world.m_8055_(pos).m_61143_((Property)FACING);
        float factor = -0.9f;
        ++spell.prismRedirect;
        if (spell.prismRedirect >= 3) {
            ANCriteriaTriggers.rewardNearbyPlayers((PlayerTrigger)ANCriteriaTriggers.PRISMATIC, (ServerLevel)world, (BlockPos)pos, (int)10);
        }
        if (spell.spellResolver == null) {
            spell.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        switch (direction) {
            case UP: 
            case DOWN: {
                Vec3 vel = spell.m_20184_();
                spell.m_20334_(vel.m_7096_(), (double)factor * vel.m_7098_(), vel.m_7094_());
                break;
            }
            case EAST: 
            case WEST: {
                Vec3 vel = spell.m_20184_();
                spell.m_20334_((double)factor * vel.m_7096_(), vel.m_7098_(), vel.m_7094_());
                break;
            }
            case NORTH: 
            case SOUTH: {
                Vec3 vel = spell.m_20184_();
                spell.m_20334_(vel.m_7096_(), vel.m_7098_(), (double)factor * vel.m_7094_());
            }
        }
        BlockUtil.updateObservers((Level)world, (BlockPos)pos);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.EAST -> east;
            case Direction.WEST -> west;
            case Direction.SOUTH -> south;
            case Direction.NORTH -> base;
            case Direction.DOWN -> ceiling;
            case Direction.UP -> floor;
        };
    }
}

