/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class DrygmyModel<T extends LivingEntity>
extends GeoModel<T> {
    private static final ResourceLocation WILD_TEXTURE = new ResourceLocation("ars_nouveau", "textures/entity/drygmy.png");
    public static final ResourceLocation NORMAL_MODEL = new ResourceLocation("ars_nouveau", "geo/drygmy.geo.json");
    public static final ResourceLocation ANIMATIONS = new ResourceLocation("ars_nouveau", "animations/drygmy_animations.json");

    public void setCustomAnimations(T entity, long uniqueID, @Nullable AnimationState<T> customPredicate) {
        super.setCustomAnimations(entity, uniqueID, customPredicate);
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraData().get(DataTickets.ENTITY_MODEL_DATA);
        head.setRotX(extraData.headPitch() * ((float)Math.PI / 180));
        head.setRotY(extraData.netHeadYaw() * ((float)Math.PI / 180));
    }

    public ResourceLocation getModelResource(T drygmy) {
        return NORMAL_MODEL;
    }

    public ResourceLocation getTextureResource(T drygmy) {
        return WILD_TEXTURE;
    }

    public ResourceLocation getAnimationResource(T drygmy) {
        return ANIMATIONS;
    }
}

