/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.common.entity.WildenChimera;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class WildenChimeraModel
extends GeoModel<WildenChimera> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("ars_nouveau", "textures/entity/wilden_chimera.png");
    public static final ResourceLocation NORMAL_MODEL = new ResourceLocation("ars_nouveau", "geo/wilden_chimera.geo.json");
    public static final ResourceLocation ANIMATIONS = new ResourceLocation("ars_nouveau", "animations/wilden_chimera_animations.json");

    public void setCustomAnimations(WildenChimera entity, long uniqueID, @Nullable AnimationState customPredicate) {
        super.setCustomAnimations((GeoAnimatable)entity, uniqueID, customPredicate);
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraData().get(DataTickets.ENTITY_MODEL_DATA);
        if (!entity.isFlying()) {
            head.setRotY(extraData.netHeadYaw() * 0.012453292f);
            head.setRotX(extraData.headPitch() * 0.037453294f);
        }
        boolean useBigWings = entity.hasWings() && (entity.isFlying() || entity.hasWings() && entity.isRamPrep());
        ((GeoBone)this.getBone("wings_folded").get()).setHidden(!entity.hasWings() || useBigWings);
        ((GeoBone)this.getBone("wings_extended_right").get()).setHidden(!useBigWings);
        ((GeoBone)this.getBone("wings_extended_left").get()).setHidden(!useBigWings);
        ((GeoBone)this.getBone("wings_extended_right2").get()).setHidden(!useBigWings);
        ((GeoBone)this.getBone("wings_extended_left2").get()).setHidden(!useBigWings);
        ((GeoBone)this.getBone("spikes_extended").get()).setHidden(!entity.isDefensive() || !entity.hasSpikes());
        ((GeoBone)this.getBone("spikes_retracted").get()).setHidden(!entity.hasSpikes() || entity.isDefensive());
        ((GeoBone)this.getBone("fins").get()).setHidden(!entity.hasSpikes());
        ((GeoBone)this.getBone("horns").get()).setHidden(!entity.hasHorns());
    }

    public ResourceLocation getModelResource(WildenChimera entity) {
        return NORMAL_MODEL;
    }

    public ResourceLocation getTextureResource(WildenChimera entity) {
        return TEXTURE;
    }

    public ResourceLocation getAnimationResource(WildenChimera animatable) {
        return ANIMATIONS;
    }
}

