/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.tile;

import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;

public class GenericModel<T extends GeoAnimatable>
extends GeoModel<T> {
    public String path;
    public ResourceLocation modelLocation;
    public ResourceLocation textLoc;
    public ResourceLocation animationLoc;
    public String textPathRoot = "block";
    public String name;

    public GenericModel(String name) {
        this.modelLocation = new ResourceLocation("ars_nouveau", "geo/" + name + ".geo.json");
        this.textLoc = new ResourceLocation("ars_nouveau", "textures/" + this.textPathRoot + "/" + name + ".png");
        this.animationLoc = new ResourceLocation("ars_nouveau", "animations/" + name + "_animations.json");
        this.name = name;
    }

    public GenericModel(String name, String textPath) {
        this(name);
        this.textPathRoot = textPath;
        this.textLoc = new ResourceLocation("ars_nouveau", "textures/" + this.textPathRoot + "/" + name + ".png");
    }

    public GenericModel withEmptyAnim() {
        this.animationLoc = new ResourceLocation("ars_nouveau", "animations/empty.json");
        return this;
    }

    public ResourceLocation getModelResource(T GeoAnimatable2) {
        return this.modelLocation;
    }

    public ResourceLocation getTextureResource(T GeoAnimatable2) {
        return this.textLoc;
    }

    public ResourceLocation getAnimationResource(T GeoAnimatable2) {
        return this.animationLoc;
    }
}

