/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.IFilter;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.util.CasterUtil;
import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.RuneTile;
import com.hollingsworth.arsnouveau.common.items.RunicChalk;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.common.util.VoxelShapeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RuneBlock
extends TickableModBlock {
    public static VoxelShape shape = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0);
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty FLOOR = BooleanProperty.m_61465_((String)"floor");
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;

    public RuneBlock() {
        this(RuneBlock.defaultProperties().m_60910_().m_60955_().m_60913_(0.0f, 0.0f));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)FLOOR, (Comparable)Boolean.valueOf(true)));
    }

    public RuneBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)context.m_43719_());
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(handIn);
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof RuneTile) {
            RuneTile runeTile = (RuneTile)blockEntity;
            if (!worldIn.f_46443_ && stack.m_41720_() instanceof RunicChalk && runeTile.isTemporary) {
                runeTile.isTemporary = false;
                PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"ars_nouveau.rune.setperm"));
                return InteractionResult.SUCCESS;
            }
            if (!(stack.m_41720_() instanceof SpellParchment) || worldIn.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            Spell spell = CasterUtil.getCaster(stack).getSpell();
            if (spell.isEmpty()) {
                return InteractionResult.SUCCESS;
            }
            if (!(spell.recipe.get(0) instanceof MethodTouch)) {
                PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"ars_nouveau.rune.touch"));
                return InteractionResult.SUCCESS;
            }
            runeTile.setSpell(spell);
            PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"ars_nouveau.spell_set"));
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        super.m_213897_(state, worldIn, pos, rand);
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof RuneTile) {
            RuneTile rune = (RuneTile)blockEntity;
            if (rune.touchedEntity != null) {
                rune.castSpell(rune.touchedEntity);
                rune.touchedEntity = null;
            }
        }
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        Object object;
        super.m_7892_(state, worldIn, pos, entityIn);
        List entities = worldIn.m_6443_(Entity.class, this.m_5940_(state, (BlockGetter)worldIn, pos, CollisionContext.m_82749_()).m_83215_().m_82338_(pos), EntitySelector.f_20408_.and(p_289691_ -> !p_289691_.m_6090_()));
        if (!entities.isEmpty() && (object = worldIn.m_7702_(pos)) instanceof RuneTile) {
            RuneTile rune = (RuneTile)object;
            if (rune.spell != null) {
                AbstractSpellPart part;
                object = rune.spell.recipe.iterator();
                while (object.hasNext() && (part = (AbstractSpellPart)object.next()) instanceof IFilter) {
                    IFilter filter = (IFilter)((Object)part);
                    if (filter.shouldResolveOnEntity(entityIn, worldIn)) continue;
                    return;
                }
            }
            rune.touchedEntity = (Entity)entities.get(0);
            worldIn.m_186460_(pos, (Block)this, 1);
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        super.m_6861_(state, world, pos, blockIn, fromPos, isMoving);
        if (!world.m_5776_() && (blockEntity = world.m_7702_(pos)) instanceof RuneTile) {
            RuneTile runeTile = (RuneTile)blockEntity;
            runeTile.disabled = world.m_276867_(pos);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        switch (facing) {
            case EAST: {
                return VoxelShapeUtils.rotate(shape, Direction.WEST);
            }
            case NORTH: {
                return VoxelShapeUtils.rotateX(shape, 270);
            }
            case DOWN: {
                return VoxelShapeUtils.rotate(shape, Direction.UP);
            }
            case WEST: {
                return VoxelShapeUtils.rotate(shape, Direction.EAST);
            }
            case SOUTH: {
                return VoxelShapeUtils.rotateX(shape, 90);
            }
        }
        return shape;
    }

    public RenderShape m_7514_(BlockState p_149645_1_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RuneTile(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED}).m_61104_(new Property[]{FACING}).m_61104_(new Property[]{FLOOR});
    }
}

