/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.google.common.collect.ImmutableMap;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.sources.SingleFile;
import net.minecraft.client.resources.model.Material;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.SpriteSourceProvider;

public class AtlasProvider
extends SpriteSourceProvider {
    public static final Map<Block, EnumMap<ChestType, Material>> MATERIALS;

    public AtlasProvider(PackOutput output, ExistingFileHelper helper) {
        super(output, helper, "ars_nouveau");
    }

    protected void addSources() {
        MATERIALS.values().stream().flatMap(e -> e.values().stream()).map(Material::m_119203_).forEach(resourceLocation -> this.atlas(CHESTS_ATLAS).addSource((SpriteSource)new SingleFile(resourceLocation, Optional.empty())));
    }

    private static EnumMap<ChestType, Material> chestMaterial(String type) {
        EnumMap<ChestType, Material> map = new EnumMap<ChestType, Material>(ChestType.class);
        map.put(ChestType.SINGLE, new Material(Sheets.f_110740_, new ResourceLocation("ars_nouveau", "model/chest/" + type + "/" + type)));
        map.put(ChestType.LEFT, new Material(Sheets.f_110740_, new ResourceLocation("ars_nouveau", "model/chest/" + type + "/left")));
        map.put(ChestType.RIGHT, new Material(Sheets.f_110740_, new ResourceLocation("ars_nouveau", "model/chest/" + type + "/right")));
        return map;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)((Block)BlockRegistry.ARCHWOOD_CHEST.get()), AtlasProvider.chestMaterial("archwood"));
        MATERIALS = builder.build();
    }
}

