/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.api.potion.PotionData;
import com.hollingsworth.arsnouveau.common.items.PotionFlask;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;

public class PacketConsumePotion {
    int inventorySlot;

    public PacketConsumePotion(FriendlyByteBuf buf) {
        this.inventorySlot = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.inventorySlot);
    }

    public PacketConsumePotion(int inventorySlot) {
        this.inventorySlot = inventorySlot;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            if (this.inventorySlot >= player.f_36093_.m_6643_()) {
                return;
            }
            ItemStack stack = player.f_36093_.m_8020_(this.inventorySlot);
            if (stack.m_41720_() instanceof PotionItem) {
                PotionData data = new PotionData(stack);
                data.applyEffects((Entity)player, (Entity)player, (LivingEntity)player);
                stack.m_41774_(1);
                player.f_36093_.m_36054_(new ItemStack((ItemLike)Items.f_42590_));
                player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11911_, SoundSource.PLAYERS, 0.5f, player.f_19853_.f_46441_.m_188501_() * 0.1f + 0.9f);
            } else if (stack.m_41720_() instanceof PotionFlask) {
                PotionFlask.FlaskData data = new PotionFlask.FlaskData(stack);
                if (data.getPotion().isEmpty() || data.getCount() <= 0) {
                    return;
                }
                data.getPotion().applyEffects((Entity)player, (Entity)player, (LivingEntity)player);
                data.setCount(data.getCount() - 1);
                player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11911_, SoundSource.PLAYERS, 0.5f, player.f_19853_.f_46441_.m_188501_() * 0.1f + 0.9f);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

