/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.beachparty.core.block.BeachGoalBlock;
import net.satisfy.beachparty.core.entity.BeachBallEntity;
import net.satisfy.beachparty.core.registry.EntityTypeRegistry;
import org.joml.Vector3d;

public class BeachGoalBlockEntity
extends BlockEntity {
    private static final int PRESENCE_THRESHOLD = 10;
    private boolean hasBeachBall = false;
    private int ballPresenceCounter = 0;

    public BeachGoalBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.BEACH_GOAL_BLOCK_ENTITY.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BeachGoalBlockEntity blockEntity) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BeachGoalBlock block = (BeachGoalBlock)state.m_60734_();
        VoxelShape detectionShape = block.getDetectionShape(state);
        VoxelShape worldShape = detectionShape.m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        AABB detectionAABB = worldShape.m_83215_();
        List balls = serverLevel.m_6443_(BeachBallEntity.class, detectionAABB.m_82400_(0.1), Entity::m_6084_);
        boolean detected = false;
        for (BeachBallEntity ball : balls) {
            VoxelShape ballShape = Shapes.m_83064_((AABB)ball.m_20191_());
            if (!Shapes.m_83157_((VoxelShape)worldShape, (VoxelShape)ballShape, (BooleanOp)BooleanOp.f_82689_)) continue;
            detected = true;
            break;
        }
        blockEntity.ballPresenceCounter = detected ? Math.min(blockEntity.ballPresenceCounter + 1, 10) : Math.max(blockEntity.ballPresenceCounter - 1, 0);
        boolean previouslyHadBall = blockEntity.hasBeachBall;
        boolean bl = blockEntity.hasBeachBall = blockEntity.ballPresenceCounter >= 10;
        if (blockEntity.hasBeachBall && !previouslyHadBall) {
            blockEntity.fireRockets(serverLevel, pos);
            level.m_46672_(pos, state.m_60734_());
        } else if (!blockEntity.hasBeachBall && previouslyHadBall) {
            level.m_46672_(pos, state.m_60734_());
        }
    }

    public boolean hasBeachBall() {
        return this.hasBeachBall;
    }

    private void fireRockets(ServerLevel world, BlockPos pos) {
        int rocketCount = world.f_46441_.m_188503_(5) + 3;
        int[][] colorOptions = new int[][]{{11393254}, {0xFFFFFF}, {16032864}};
        for (int i = 0; i < rocketCount; ++i) {
            double dx = (world.f_46441_.m_188500_() - 0.5) * 0.2;
            double dz = (world.f_46441_.m_188500_() - 0.5) * 0.2;
            double dy = 1.2 + (world.f_46441_.m_188500_() - 0.5) * 0.1;
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 2.0;
            double z = (double)pos.m_123343_() + 0.5;
            ItemStack fireworkItem = new ItemStack((ItemLike)Items.f_42688_);
            CompoundTag fireworkTag = new CompoundTag();
            CompoundTag explosion = new CompoundTag();
            int[] colors = colorOptions[world.f_46441_.m_188503_(colorOptions.length)];
            explosion.m_128385_("Colors", colors);
            explosion.m_128344_("Type", (byte)1);
            ListTag explosionsList = new ListTag();
            explosionsList.add((Object)explosion);
            CompoundTag fireworks = new CompoundTag();
            fireworks.m_128344_("Flight", (byte)1);
            fireworks.m_128365_("Explosions", (Tag)explosionsList);
            fireworkTag.m_128365_("Fireworks", (Tag)fireworks);
            fireworkItem.m_41751_(fireworkTag);
            FireworkRocketEntity rocket = new FireworkRocketEntity((Level)world, x, y, z, fireworkItem);
            Vector3d velocity = new Vector3d(dx, dy, dz);
            rocket.m_20334_(velocity.x, velocity.y, velocity.z);
            world.m_7967_((Entity)rocket);
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("HasBeachBall", this.hasBeachBall);
        tag.m_128405_("BallPresenceCounter", this.ballPresenceCounter);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.hasBeachBall = tag.m_128471_("HasBeachBall");
        this.ballPresenceCounter = tag.m_128451_("BallPresenceCounter");
    }
}

