/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.item;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageInABottleItem
extends BlockItem {
    public MessageInABottleItem(Block block, Item.Properties settings) {
        super(block, settings);
    }

    @Nullable
    public static ItemStack getRandomMap(Entity entity) {
        int index = entity.m_9236_().m_213780_().m_188503_(4);
        return switch (index) {
            case 0 -> MessageInABottleItem.createMansionMap(entity);
            case 1 -> MessageInABottleItem.createShipwreckMap(entity);
            case 2 -> MessageInABottleItem.createMonumentMap(entity);
            case 3 -> MessageInABottleItem.createTreasureMap(entity);
            default -> null;
        };
    }

    public static ItemStack createMonumentMap(Entity entity) {
        return MessageInABottleItem.createMap(entity, (TagKey<Structure>)StructureTags.f_215885_, "filled_map.monument", MapDecoration.Type.MONUMENT);
    }

    public static ItemStack createMansionMap(Entity entity) {
        return MessageInABottleItem.createMap(entity, (TagKey<Structure>)StructureTags.f_215884_, "filled_map.mansion", MapDecoration.Type.MANSION);
    }

    public static ItemStack createShipwreckMap(Entity entity) {
        return MessageInABottleItem.createMap(entity, (TagKey<Structure>)StructureTags.f_215891_, "filled_map.shipwreck", MapDecoration.Type.RED_X);
    }

    public static ItemStack createTreasureMap(Entity entity) {
        return MessageInABottleItem.createMap(entity, (TagKey<Structure>)StructureTags.f_215886_, "filled_map.treasure", MapDecoration.Type.RED_X);
    }

    @Nullable
    public static ItemStack createMap(Entity entity, TagKey<Structure> structure, String nameKey, MapDecoration.Type iconType) {
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverWorld = (ServerLevel)level;
        BlockPos pos = serverWorld.m_215011_(structure, entity.m_20183_(), 100, true);
        if (pos != null) {
            ItemStack stack = MapItem.m_42886_((Level)serverWorld, (int)pos.m_123341_(), (int)pos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
            MapItem.m_42850_((ServerLevel)serverWorld, (ItemStack)stack);
            MapItemSavedData.m_77925_((ItemStack)stack, (BlockPos)pos, (String)"+", (MapDecoration.Type)iconType);
            stack.m_41714_((Component)Component.m_237115_((String)nameKey));
            return stack;
        }
        return null;
    }

    private static void spawnItem(Level world, double x, double y, double z, ItemStack stack) {
        world.m_7967_((Entity)new ItemEntity(world, x, y, z, stack));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (world.m_5776_()) {
            return InteractionResultHolder.m_19090_((Object)user.m_21120_(hand));
        }
        RandomSource random = world.m_213780_();
        int randomNumber = random.m_188503_(100);
        ItemStack dropStack = randomNumber < 50 ? new ItemStack((ItemLike)Items.f_42516_) : (randomNumber < 80 ? new ItemStack((ItemLike)Items.f_42676_) : MessageInABottleItem.getRandomMap((Entity)user));
        if (dropStack == null) {
            dropStack = new ItemStack((ItemLike)Items.f_42516_);
        }
        double x = user.m_20185_();
        double y = user.m_20186_();
        double z = user.m_20189_();
        MessageInABottleItem.spawnItem(world, x, y, z, dropStack);
        MessageInABottleItem.spawnItem(world, x, y, z, new ItemStack((ItemLike)Items.f_42590_));
        user.m_21120_(hand).m_41774_(1);
        return InteractionResultHolder.m_19090_((Object)user.m_21120_(hand));
    }
}

