/*
 * Decompiled with CFR 0.152.
 */
package de.nekeras.borderless.client;

import de.nekeras.borderless.client.fullscreen.FullscreenDisplayMode;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.system.Platform;

@OnlyIn(value=Dist.CLIENT)
public enum DesktopEnvironment {
    WINDOWS(FullscreenDisplayMode.BORDERLESS),
    X11(FullscreenDisplayMode.NATIVE_NON_ICONIFY),
    WAYLAND(FullscreenDisplayMode.NATIVE_NON_ICONIFY),
    GENERIC(FullscreenDisplayMode.NATIVE);

    private static final String LINUX_WINDOW_SYSTEM_VARIABLE = "XDG_SESSION_TYPE";
    private static final String X11_NAME = "x11";
    private static final String WAYLAND_NAME = "wayland";
    private static final DesktopEnvironment CURRENT;
    private static final Logger log;
    private final FullscreenDisplayMode bestFullscreenDisplayMode;

    private DesktopEnvironment(FullscreenDisplayMode bestFullscreenDisplayMode) {
        this.bestFullscreenDisplayMode = bestFullscreenDisplayMode;
    }

    @Nonnull
    public FullscreenDisplayMode getBestFullscreenDisplayMode() {
        return this.bestFullscreenDisplayMode;
    }

    @Nonnull
    public static DesktopEnvironment get() {
        return CURRENT;
    }

    static {
        log = LogManager.getLogger();
        log.info("Determining desktop environment");
        DesktopEnvironment current = null;
        switch (Platform.get()) {
            case WINDOWS: {
                current = WINDOWS;
                break;
            }
            case LINUX: {
                String result = System.getenv(LINUX_WINDOW_SYSTEM_VARIABLE);
                if (X11_NAME.equalsIgnoreCase(result)) {
                    current = X11;
                    break;
                }
                if (WAYLAND_NAME.equalsIgnoreCase(result)) {
                    current = WAYLAND;
                    break;
                }
                current = GENERIC;
                log.warn("Unknown window system: {}", (Object)result);
                break;
            }
            case MACOSX: {
                current = GENERIC;
            }
        }
        CURRENT = current;
        log.info("Found desktop environment {}", (Object)CURRENT);
    }
}

