/*
 * Decompiled with CFR 0.152.
 */
package de.nekeras.borderless.client;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.platform.WindowEventHandler;
import de.nekeras.borderless.client.GlfwUtils;
import de.nekeras.borderless.client.ReflectionUtils;
import de.nekeras.borderless.client.fullscreen.FullscreenDisplayMode;
import de.nekeras.borderless.client.listener.SizeChangedWindowEventHandler;
import de.nekeras.borderless.config.Config;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class FullscreenDisplayModeHolder {
    private static final Logger log = LogManager.getLogger();
    private static final Window window = Minecraft.m_91087_().m_91268_();
    private static FullscreenDisplayMode currentMode;

    public static void initMinecraft() {
        log.info("Overwriting Minecraft WindowEventListener");
        ReflectionUtils.updateWindowEventListener(window, oldListener -> new SizeChangedWindowEventHandler((WindowEventHandler)oldListener, FullscreenDisplayModeHolder::setFullscreenDisplayModeFromConfig));
        log.info("Overwrite finished");
        FullscreenDisplayModeHolder.setFullscreenDisplayModeFromConfig();
    }

    public static void setFullscreenDisplayMode(@Nullable FullscreenDisplayMode newMode) {
        log.info("Detected fullscreen mode change from {} to {}", (Object)currentMode, (Object)newMode);
        if (currentMode != null) {
            currentMode.reset(window);
        }
        log.info("Refreshing {}", (Object)newMode);
        if (newMode != null) {
            if (window.m_85440_()) {
                newMode.apply(window);
            } else {
                newMode.reset(window);
            }
        }
        currentMode = newMode;
        GlfwUtils.checkInputMode(window);
    }

    public static void setFullscreenDisplayModeFromConfig() {
        FullscreenDisplayMode configMode = Config.getFullscreenDisplayMode();
        log.info("Refreshing fullscreen mode from config to {}", (Object)configMode);
        FullscreenDisplayModeHolder.setFullscreenDisplayMode(configMode);
    }
}

