/*
 * Decompiled with CFR 0.152.
 */
package de.nekeras.borderless.util;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AccessibleFieldDelegate<C, F> {
    private final Field field;
    private Function<C, F> defaultSupplier;

    public AccessibleFieldDelegate(@Nonnull Class<C> inClass, @Nonnull Class<F> fieldClass) throws NoSuchFieldException {
        Optional<Field> field = AccessibleFieldDelegate.findFieldOfType(inClass, fieldClass);
        if (!field.isPresent()) {
            throw new NoSuchFieldException(String.format("Failed to find field of type %s in type %s", fieldClass.getName(), inClass));
        }
        this.field = field.get();
    }

    public AccessibleFieldDelegate(@Nonnull Class<C> inClass, @Nonnull Class<F> fieldClass, @Nonnull Function<C, F> defaultSupplier) {
        Optional<Field> field = AccessibleFieldDelegate.findFieldOfType(inClass, fieldClass);
        if (field.isPresent()) {
            this.field = field.get();
        } else {
            this.field = null;
            this.defaultSupplier = defaultSupplier;
        }
    }

    @Nullable
    public F getValue(@Nonnull C thisRef) {
        if (this.field == null) {
            return this.defaultSupplier.apply(thisRef);
        }
        try {
            return (F)this.field.get(thisRef);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(String.format("Failed to access field %s in %s", this.field.getType().getName(), thisRef.getClass().getName()), e);
        }
    }

    public void setValue(@Nonnull C thisRef, @Nullable F value) {
        if (this.field != null) {
            try {
                this.field.set(thisRef, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(String.format("Failed to access field %s in %s", this.field.getType().getName(), thisRef.getClass().getName()), e);
            }
        }
    }

    @Nonnull
    private static <C, F> Optional<Field> findFieldOfType(@Nonnull Class<C> inClass, @Nonnull Class<F> fieldType) {
        Optional<Field> field = Arrays.stream(inClass.getDeclaredFields()).filter(f -> f.getType() == fieldType).findFirst();
        if (field.isPresent()) {
            Field resultField = field.get();
            resultField.setAccessible(true);
            return Optional.of(resultField);
        }
        return Optional.empty();
    }
}

