/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.cubeswithoutborders.client.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.platform.Monitor;
import com.mojang.blaze3d.platform.ScreenManager;
import com.mojang.blaze3d.platform.VideoMode;
import com.mojang.blaze3d.platform.Window;
import dev.kir.cubeswithoutborders.client.FullscreenManager;
import dev.kir.cubeswithoutborders.client.FullscreenMode;
import dev.kir.cubeswithoutborders.client.FullscreenType;
import dev.kir.cubeswithoutborders.client.FullscreenTypes;
import dev.kir.cubeswithoutborders.client.MonitorInfo;
import dev.kir.cubeswithoutborders.client.MonitorLookup;
import dev.kir.cubeswithoutborders.client.ResizableGameRenderer;
import dev.kir.cubeswithoutborders.client.config.CubesWithoutBordersConfig;
import dev.kir.cubeswithoutborders.client.util.SystemUtil;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={Window.class})
abstract class WindowMixin
implements FullscreenManager {
    @Shadow
    @Final
    private ScreenManager f_85348_;
    @Shadow
    private Optional<VideoMode> f_85354_;
    @Shadow
    private int f_85350_;
    @Shadow
    private int f_85351_;
    @Shadow
    private int f_85352_;
    @Shadow
    private int f_85353_;
    @Shadow
    private boolean f_85355_;
    @Shadow
    private boolean f_85356_;
    private boolean borderless;
    private FullscreenType previousFullscreenType;
    private FullscreenType currentFullscreenType;

    WindowMixin() {
    }

    @Override
    public FullscreenMode getFullscreenMode() {
        return this.f_85355_ ? (this.borderless ? FullscreenMode.BORDERLESS : FullscreenMode.ON) : FullscreenMode.OFF;
    }

    @Override
    public void setFullscreenMode(FullscreenMode fullscreenMode) {
        FullscreenMode currentFullscreenMode = this.getFullscreenMode();
        boolean bl = this.f_85355_ = fullscreenMode != FullscreenMode.OFF;
        this.borderless = this.f_85355_ ? fullscreenMode == FullscreenMode.BORDERLESS : this.borderless;
        this.f_85356_ = currentFullscreenMode == fullscreenMode == this.f_85355_;
        Minecraft.m_91087_().f_91066_.m_231829_().m_231514_((Object)this.f_85355_);
    }

    @WrapOperation(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/util/MonitorTracker;getMonitor(J)Lnet/minecraft/client/util/Monitor;")})
    private Monitor fixupMonitor(ScreenManager monitorTracker, long pointer, Operation<Monitor> getMonitor) {
        this.f_85356_ = false;
        this.f_85355_ = false;
        CubesWithoutBordersConfig config = CubesWithoutBordersConfig.getInstance();
        Monitor monitor = (Monitor)getMonitor.call(new Object[]{monitorTracker, pointer});
        Optional<Monitor> preferredMonitor = MonitorLookup.findMonitor(monitorTracker, config.getPreferredMonitor());
        return SystemUtil.isWindows() ? preferredMonitor.orElse(monitor) : monitor;
    }

    @WrapOperation(method={"<init>"}, at={@At(value="INVOKE", target="Lorg/lwjgl/glfw/GLFW;glfwMakeContextCurrent(J)V")})
    private void init(long handle, Operation<Void> glfwMakeContextCurrent) {
        Window window = (Window)this;
        CubesWithoutBordersConfig config = CubesWithoutBordersConfig.getInstance();
        this.f_85356_ = config.getFullscreenMode() != FullscreenMode.OFF;
        this.f_85355_ = this.f_85356_;
        this.borderless = config.getPreferredFullscreenMode() == FullscreenMode.BORDERLESS;
        this.borderless = this.borderless || config.getFullscreenMode() == FullscreenMode.BORDERLESS;
        this.currentFullscreenType = null;
        this.previousFullscreenType = null;
        Monitor currentMonitor = this.f_85348_.m_85276_(window);
        Monitor preferredMonitor = MonitorLookup.findMonitor(this.f_85348_, config.getPreferredMonitor()).orElse(currentMonitor);
        if (preferredMonitor != currentMonitor && SystemUtil.isWindows()) {
            VideoMode videoMode = preferredMonitor.m_84950_();
            this.f_85350_ = window.f_85357_ = preferredMonitor.m_84951_() + (videoMode.m_85332_() - window.f_85359_) / 2;
            this.f_85351_ = window.f_85358_ = preferredMonitor.m_84952_() + (videoMode.m_85335_() - window.f_85360_) / 2;
            GLFW.glfwSetWindowMonitor((long)handle, (long)0L, (int)window.f_85357_, (int)window.f_85358_, (int)window.f_85359_, (int)window.f_85360_, (int)-1);
        }
        glfwMakeContextCurrent.call(new Object[]{handle});
    }

    @Inject(method={"updateWindowRegion"}, at={@At(value="HEAD")}, cancellable=true)
    private void enableFullscreen(CallbackInfo ci) {
        boolean wasInWindowedMode;
        Window window = (Window)this;
        CubesWithoutBordersConfig config = CubesWithoutBordersConfig.getInstance();
        this.previousFullscreenType = this.currentFullscreenType;
        if (!this.f_85355_) {
            this.currentFullscreenType = null;
            return;
        }
        FullscreenType requestedFullscreenType = this.borderless ? config.getBorderlessFullscreenType() : config.getFullscreenType();
        FullscreenType defaultFullscreenType = this.borderless ? FullscreenTypes.borderless() : FullscreenTypes.exclusive();
        this.currentFullscreenType = FullscreenTypes.validate(requestedFullscreenType, defaultFullscreenType);
        Monitor monitor = this.f_85348_.m_85276_(window);
        if (monitor == null) {
            this.currentFullscreenType = null;
            return;
        }
        if (this.currentFullscreenType == FullscreenTypes.DEFAULT) {
            return;
        }
        boolean bl = wasInWindowedMode = this.previousFullscreenType == null;
        if (wasInWindowedMode) {
            this.f_85350_ = window.f_85357_;
            this.f_85351_ = window.f_85358_;
            this.f_85352_ = window.f_85359_;
            this.f_85353_ = window.f_85360_;
        } else {
            this.previousFullscreenType.disable(window);
            ResizableGameRenderer.getInstance().disable();
        }
        VideoMode videoMode = monitor.m_84948_(this.f_85354_);
        this.currentFullscreenType.enable(window, monitor, videoMode);
        int targetWidth = videoMode.m_85332_();
        int targetHeight = videoMode.m_85335_();
        int deltaWidth = Math.abs(window.f_85359_ - targetWidth);
        int deltaHeight = Math.abs(window.f_85360_ - targetHeight);
        if (deltaWidth > 1 || deltaHeight > 1) {
            float targetScale = Math.min((float)targetWidth / (float)window.f_85359_, (float)targetHeight / (float)window.f_85360_);
            int scaledWidth = Math.round((float)window.f_85359_ * targetScale);
            int scaledHeight = Math.round((float)window.f_85360_ * targetScale);
            ResizableGameRenderer.getInstance().resize(scaledWidth, scaledHeight);
        }
        ci.cancel();
    }

    @Inject(method={"updateWindowRegion"}, at={@At(value="INVOKE", target="Lorg/lwjgl/glfw/GLFW;glfwSetWindowMonitor(JJIIIII)V", ordinal=0), @At(value="FIELD", target="Lnet/minecraft/client/util/Window;windowedX:I", ordinal=1)})
    private void disableFullscreen(CallbackInfo ci) {
        if (this.previousFullscreenType == null) {
            return;
        }
        this.previousFullscreenType.disable((Window)this);
        ResizableGameRenderer.getInstance().disable();
    }

    @WrapOperation(method={"updateWindowRegion"}, at={@At(value="INVOKE", target="Lorg/lwjgl/glfw/GLFW;glfwGetWindowMonitor(J)J", ordinal=0)})
    private long getWindowMonitorIfWindowed(long handle, Operation<Long> getWindowMonitor) {
        if (this.previousFullscreenType != null) {
            return -1L;
        }
        return (Long)getWindowMonitor.call(new Object[]{handle});
    }

    @Inject(method={"close"}, at={@At(value="HEAD")})
    private void save(CallbackInfo ci) {
        Window window = (Window)this;
        Monitor monitor = this.f_85348_.m_85276_(window);
        CubesWithoutBordersConfig config = CubesWithoutBordersConfig.getInstance();
        config.setFullscreenMode(this.getFullscreenMode());
        config.setPreferredFullscreenMode(this.borderless ? FullscreenMode.BORDERLESS : FullscreenMode.ON);
        config.setPreferredMonitor(monitor == null ? MonitorInfo.primary() : MonitorInfo.of(monitor));
        config.save();
        Options options = Minecraft.m_91087_().f_91066_;
        options.m_231829_().m_231514_((Object)this.f_85355_);
        options.m_92169_();
    }
}

