/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.connectiblechains.client.render.entity;

import com.lilypuree.connectiblechains.ConnectibleChains;
import com.lilypuree.connectiblechains.client.render.entity.ChainModel;
import com.lilypuree.connectiblechains.client.render.entity.UVRect;
import com.lilypuree.connectiblechains.util.Helper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ChainRenderer {
    private static final float CHAIN_SCALE = 1.0f;
    private static final int MAX_SEGMENTS = 2048;
    private final Object2ObjectOpenHashMap<BakeKey, ChainModel> models = new Object2ObjectOpenHashMap(256);

    public void renderBaked(VertexConsumer buffer, PoseStack matrices, BakeKey key, Vector3f chainVec, int blockLight0, int blockLight1, int skyLight0, int skyLight1) {
        ChainModel model;
        if (this.models.containsKey((Object)key)) {
            model = (ChainModel)this.models.get((Object)key);
        } else {
            model = this.buildModel(chainVec);
            this.models.put((Object)key, (Object)model);
            if (!FMLEnvironment.production && this.models.size() > 10000) {
                ConnectibleChains.LOGGER.error("Chain model leak found!!!!!");
            }
        }
        model.render(buffer, matrices, blockLight0, blockLight1, skyLight0, skyLight1);
    }

    private ChainModel buildModel(Vector3f chainVec) {
        float desiredSegmentLength = 1.0f / (float)ConnectibleChains.runtimeConfig.getQuality();
        int initialCapacity = (int)(2.0f * chainVec.lengthSquared() / desiredSegmentLength);
        ChainModel.Builder builder = ChainModel.builder(initialCapacity);
        if (chainVec.x() == 0.0f && chainVec.z() == 0.0f) {
            this.buildFaceVertical(builder, chainVec, 45.0f, UVRect.DEFAULT_SIDE_A);
            this.buildFaceVertical(builder, chainVec, -45.0f, UVRect.DEFAULT_SIDE_B);
        } else {
            this.buildFace(builder, chainVec, 45.0f, UVRect.DEFAULT_SIDE_A);
            this.buildFace(builder, chainVec, -45.0f, UVRect.DEFAULT_SIDE_B);
        }
        return builder.build();
    }

    private void buildFaceVertical(ChainModel.Builder builder, Vector3f v, float angle, UVRect uv) {
        float actualSegmentLength = 1.0f / (float)ConnectibleChains.runtimeConfig.getQuality();
        float chainWidth = (uv.x1() - uv.x0()) / 16.0f * 1.0f;
        Vector3f normal = new Vector3f((float)Math.cos(Math.toRadians(angle)), 0.0f, (float)Math.sin(Math.toRadians(angle)));
        normal.normalize(chainWidth);
        Vector3f vert00 = new Vector3f(-normal.x() / 2.0f, 0.0f, -normal.z() / 2.0f);
        Vector3f vert01 = new Vector3f((Vector3fc)vert00);
        vert01.add((Vector3fc)normal);
        Vector3f vert10 = new Vector3f(-normal.x() / 2.0f, 0.0f, -normal.z() / 2.0f);
        Vector3f vert11 = new Vector3f((Vector3fc)vert10);
        vert11.add((Vector3fc)normal);
        float uvv0 = 0.0f;
        float uvv1 = 0.0f;
        boolean lastIter_ = false;
        for (int segment = 0; segment < 2048; ++segment) {
            if (vert00.y() + actualSegmentLength >= v.y()) {
                lastIter_ = true;
                actualSegmentLength = v.y() - vert00.y();
            }
            vert10.add(0.0f, actualSegmentLength, 0.0f);
            vert11.add(0.0f, actualSegmentLength, 0.0f);
            builder.vertex(vert00).uv(uv.x0() / 16.0f, uvv0).next();
            builder.vertex(vert01).uv(uv.x1() / 16.0f, uvv0).next();
            builder.vertex(vert11).uv(uv.x1() / 16.0f, uvv1 += actualSegmentLength / 1.0f).next();
            builder.vertex(vert10).uv(uv.x0() / 16.0f, uvv1).next();
            if (lastIter_) break;
            uvv0 = uvv1;
            vert00.set((Vector3fc)vert10);
            vert01.set((Vector3fc)vert11);
        }
    }

    private void buildFace(ChainModel.Builder builder, Vector3f v, float angle, UVRect uv) {
        float desiredSegmentLength = 1.0f / (float)ConnectibleChains.runtimeConfig.getQuality();
        float distance = v.length();
        float distanceXZ = (float)Math.sqrt(Math.fma(v.x(), v.x(), v.z() * v.z()));
        float wrongDistanceFactor = distance / distanceXZ;
        Vector3f vert00 = new Vector3f();
        Vector3f vert01 = new Vector3f();
        Vector3f vert11 = new Vector3f();
        Vector3f vert10 = new Vector3f();
        Vector3f normal = new Vector3f();
        Vector3f rotAxis = new Vector3f();
        float chainWidth = (uv.x1() - uv.x0()) / 16.0f * 1.0f;
        float uvv1 = 0.0f;
        Vector3f point0 = new Vector3f();
        Vector3f point1 = new Vector3f();
        Quaternionf rotator = new Quaternionf();
        point0.set(0.0f, (float)Helper.drip2(0.0, distance, v.y()), 0.0f);
        float gradient = (float)Helper.drip2prime(0.0, distance, v.y());
        normal.set(-gradient, Math.abs(distanceXZ / distance), 0.0f);
        normal.normalize();
        float x = this.estimateDeltaX(desiredSegmentLength, gradient);
        gradient = (float)Helper.drip2prime(x * wrongDistanceFactor, distance, v.y());
        float y = (float)Helper.drip2(x * wrongDistanceFactor, distance, v.y());
        point1.set(x, y, 0.0f);
        rotAxis.set(point1.x() - point0.x(), point1.y() - point0.y(), point1.z() - point0.z());
        rotAxis.normalize();
        rotator.fromAxisAngleDeg((Vector3fc)rotAxis, angle);
        normal.rotate((Quaternionfc)rotator);
        normal.normalize(chainWidth);
        vert10.set(point0.x() - normal.x() / 2.0f, point0.y() - normal.y() / 2.0f, point0.z() - normal.z() / 2.0f);
        vert11.set((Vector3fc)vert10);
        vert11.add((Vector3fc)normal);
        float actualSegmentLength = point0.distance((Vector3fc)point1);
        boolean lastIter_ = false;
        for (int segment = 0; segment < 2048; ++segment) {
            rotAxis.set(point1.x() - point0.x(), point1.y() - point0.y(), point1.z() - point0.z());
            rotAxis.normalize();
            rotator = rotator.fromAxisAngleDeg((Vector3fc)rotAxis, angle);
            normal.set(-gradient, Math.abs(distanceXZ / distance), 0.0f);
            normal.normalize();
            normal.rotate((Quaternionfc)rotator);
            normal.normalize(chainWidth);
            vert00.set((Vector3fc)vert10);
            vert01.set((Vector3fc)vert11);
            vert10.set(point1.x() - normal.x() / 2.0f, point1.y() - normal.y() / 2.0f, point1.z() - normal.z() / 2.0f);
            vert11.set((Vector3fc)vert10);
            vert11.add((Vector3fc)normal);
            float uvv0 = uvv1;
            uvv1 = uvv0 + actualSegmentLength / 1.0f;
            builder.vertex(vert00).uv(uv.x0() / 16.0f, uvv0).next();
            builder.vertex(vert01).uv(uv.x1() / 16.0f, uvv0).next();
            builder.vertex(vert11).uv(uv.x1() / 16.0f, uvv1).next();
            builder.vertex(vert10).uv(uv.x0() / 16.0f, uvv1).next();
            if (lastIter_) break;
            point0.set((Vector3fc)point1);
            x += this.estimateDeltaX(desiredSegmentLength, gradient);
            if (x >= distanceXZ) {
                lastIter_ = true;
                x = distanceXZ;
            }
            gradient = (float)Helper.drip2prime(x * wrongDistanceFactor, distance, v.y());
            y = (float)Helper.drip2(x * wrongDistanceFactor, distance, v.y());
            point1.set(x, y, 0.0f);
            actualSegmentLength = point0.distance((Vector3fc)point1);
        }
    }

    private float estimateDeltaX(float s, float k) {
        return (float)((double)s / Math.sqrt(1.0f + k * k));
    }

    public void render(VertexConsumer buffer, PoseStack matrices, Vector3f chainVec, int blockLight0, int blockLight1, int skyLight0, int skyLight1) {
        ChainModel model = this.buildModel(chainVec);
        model.render(buffer, matrices, blockLight0, blockLight1, skyLight0, skyLight1);
    }

    public void purge() {
        this.models.clear();
    }

    public static class BakeKey {
        private final int hash;

        public BakeKey(Vec3 srcPos, Vec3 dstPos) {
            float dY = (float)(srcPos.f_82480_ - dstPos.f_82480_);
            float dXZ = new Vector3f((float)srcPos.f_82479_, 0.0f, (float)srcPos.f_82481_).distance((float)dstPos.f_82479_, 0.0f, (float)dstPos.f_82481_);
            int hash = Float.floatToIntBits(dY);
            this.hash = hash = 31 * hash + Float.floatToIntBits(dXZ);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BakeKey bakeKey = (BakeKey)o;
            return this.hash == bakeKey.hash;
        }
    }
}

