/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.model;

import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;

public class BakedModelHelper {
    public static int[] cropAndMove(int[] vertexData, TextureAtlasSprite sprite, AABB crop, Vec3 move) {
        vertexData = Arrays.copyOf(vertexData, vertexData.length);
        Vec3 xyz0 = BakedQuadHelper.getXYZ(vertexData, 0);
        Vec3 xyz1 = BakedQuadHelper.getXYZ(vertexData, 1);
        Vec3 xyz2 = BakedQuadHelper.getXYZ(vertexData, 2);
        Vec3 xyz3 = BakedQuadHelper.getXYZ(vertexData, 3);
        Vec3 uAxis = xyz3.m_82549_(xyz2).m_82490_(0.5);
        Vec3 vAxis = xyz1.m_82549_(xyz2).m_82490_(0.5);
        Vec3 center = xyz3.m_82549_(xyz2).m_82549_(xyz0).m_82549_(xyz1).m_82490_(0.25);
        float u0 = BakedQuadHelper.getU(vertexData, 0);
        float u3 = BakedQuadHelper.getU(vertexData, 3);
        float v0 = BakedQuadHelper.getV(vertexData, 0);
        float v1 = BakedQuadHelper.getV(vertexData, 1);
        float uScale = Math.round((double)(SpriteShiftEntry.getUnInterpolatedU(sprite, u3) - SpriteShiftEntry.getUnInterpolatedU(sprite, u0)) / xyz3.m_82554_(xyz0));
        float vScale = Math.round((double)(SpriteShiftEntry.getUnInterpolatedV(sprite, v1) - SpriteShiftEntry.getUnInterpolatedV(sprite, v0)) / xyz1.m_82554_(xyz0));
        if (uScale == 0.0f) {
            float v3 = BakedQuadHelper.getV(vertexData, 3);
            float u1 = BakedQuadHelper.getU(vertexData, 1);
            uAxis = xyz1.m_82549_(xyz2).m_82490_(0.5);
            vAxis = xyz3.m_82549_(xyz2).m_82490_(0.5);
            uScale = Math.round((double)(SpriteShiftEntry.getUnInterpolatedU(sprite, u1) - SpriteShiftEntry.getUnInterpolatedU(sprite, u0)) / xyz1.m_82554_(xyz0));
            vScale = Math.round((double)(SpriteShiftEntry.getUnInterpolatedV(sprite, v3) - SpriteShiftEntry.getUnInterpolatedV(sprite, v0)) / xyz3.m_82554_(xyz0));
        }
        uAxis = uAxis.m_82546_(center).m_82541_();
        vAxis = vAxis.m_82546_(center).m_82541_();
        Vec3 min = new Vec3(crop.f_82288_, crop.f_82289_, crop.f_82290_);
        Vec3 max = new Vec3(crop.f_82291_, crop.f_82292_, crop.f_82293_);
        for (int vertex = 0; vertex < 4; ++vertex) {
            Vec3 xyz = BakedQuadHelper.getXYZ(vertexData, vertex);
            Vec3 newXyz = VecHelper.componentMin(max, VecHelper.componentMax(xyz, min));
            Vec3 diff = newXyz.m_82546_(xyz);
            if (diff.m_82556_() > 0.0) {
                float u = BakedQuadHelper.getU(vertexData, vertex);
                float v = BakedQuadHelper.getV(vertexData, vertex);
                float uDiff = (float)uAxis.m_82526_(diff) * uScale;
                float vDiff = (float)vAxis.m_82526_(diff) * vScale;
                BakedQuadHelper.setU(vertexData, vertex, sprite.m_118367_((double)(SpriteShiftEntry.getUnInterpolatedU(sprite, u) + uDiff)));
                BakedQuadHelper.setV(vertexData, vertex, sprite.m_118393_((double)(SpriteShiftEntry.getUnInterpolatedV(sprite, v) + vDiff)));
            }
            BakedQuadHelper.setXYZ(vertexData, vertex, newXyz.m_82549_(move));
        }
        return vertexData;
    }

    public static BakedModel generateModel(BakedModel template, UnaryOperator<TextureAtlasSprite> spriteSwapper) {
        RandomSource random = RandomSource.m_216327_();
        EnumMap<Direction, List<BakedQuad>> culledFaces = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
        for (Direction cullFace : Iterate.directions) {
            random.m_188584_(42L);
            List quads = template.getQuads(null, cullFace, random, ModelData.EMPTY, RenderType.m_110451_());
            culledFaces.put(cullFace, BakedModelHelper.swapSprites(quads, spriteSwapper));
        }
        random.m_188584_(42L);
        List quads = template.getQuads(null, null, random, ModelData.EMPTY, RenderType.m_110451_());
        List<BakedQuad> unculledFaces = BakedModelHelper.swapSprites(quads, spriteSwapper);
        TextureAtlasSprite particleSprite = template.getParticleIcon(ModelData.EMPTY);
        TextureAtlasSprite swappedParticleSprite = (TextureAtlasSprite)spriteSwapper.apply(particleSprite);
        if (swappedParticleSprite != null) {
            particleSprite = swappedParticleSprite;
        }
        return new SimpleBakedModel(unculledFaces, culledFaces, template.m_7541_(), template.m_7547_(), template.m_7539_(), particleSprite, template.m_7442_(), ItemOverrides.f_111734_);
    }

    public static List<BakedQuad> swapSprites(List<BakedQuad> quads, UnaryOperator<TextureAtlasSprite> spriteSwapper) {
        ArrayList<BakedQuad> newQuads = new ArrayList<BakedQuad>(quads);
        int size = quads.size();
        for (int i = 0; i < size; ++i) {
            BakedQuad quad = quads.get(i);
            TextureAtlasSprite sprite = quad.m_173410_();
            TextureAtlasSprite newSprite = (TextureAtlasSprite)spriteSwapper.apply(sprite);
            if (newSprite == null || sprite == newSprite) continue;
            BakedQuad newQuad = BakedQuadHelper.clone(quad);
            int[] vertexData = newQuad.m_111303_();
            for (int vertex = 0; vertex < 4; ++vertex) {
                float u = BakedQuadHelper.getU(vertexData, vertex);
                float v = BakedQuadHelper.getV(vertexData, vertex);
                BakedQuadHelper.setU(vertexData, vertex, newSprite.m_118367_((double)SpriteShiftEntry.getUnInterpolatedU(sprite, u)));
                BakedQuadHelper.setV(vertexData, vertex, newSprite.m_118393_((double)SpriteShiftEntry.getUnInterpolatedV(sprite, v)));
            }
            newQuads.set(i, newQuad);
        }
        return newQuads;
    }
}

