/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.boring;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionCollider;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.TranslatingContraption;
import com.simibubi.create.content.contraptions.bearing.BearingContraption;
import com.simibubi.create.content.contraptions.bearing.MechanicalBearingBlockEntity;
import com.simibubi.create.content.contraptions.piston.MechanicalPistonBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.CBCTags;
import rbasamoyai.createbigcannons.base.CBCRegistries;
import rbasamoyai.createbigcannons.base.PoleContraption;
import rbasamoyai.createbigcannons.base.PoleMoverBlockEntity;
import rbasamoyai.createbigcannons.cannons.CannonBehavior;
import rbasamoyai.createbigcannons.cannons.ICannonBlockEntity;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.crafting.BlockRecipeType;
import rbasamoyai.createbigcannons.crafting.BlockRecipesManager;
import rbasamoyai.createbigcannons.crafting.boring.CannonDrillBlock;
import rbasamoyai.createbigcannons.crafting.boring.CannonDrillingContraption;
import rbasamoyai.createbigcannons.crafting.boring.DrillBoringBlockRecipe;
import rbasamoyai.createbigcannons.crafting.builtup.LayeredBigCannonBlockEntity;
import rbasamoyai.createbigcannons.crafting.casting.CannonCastShape;
import rbasamoyai.createbigcannons.index.CBCBlocks;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.network.ClientboundUpdateContraptionPacket;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public abstract class AbstractCannonDrillBlockEntity
extends PoleMoverBlockEntity {
    protected AbstractContraptionEntity latheEntity;
    protected BlockPos boringPos;
    protected float boreSpeed;
    protected float addedStressImpact;
    protected FailureReason failureReason = FailureReason.NONE;
    private DrillBoringBlockRecipe currentRecipe;

    protected AbstractCannonDrillBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        BlockPos blockPos = this.boringPos = compound.m_128441_("BoringPos") ? NbtUtils.m_129239_((CompoundTag)compound.m_128469_("BoringPos")) : null;
        if (!clientPacket) {
            return;
        }
        this.boreSpeed = compound.m_128457_("BoreSpeed");
        this.addedStressImpact = compound.m_128457_("AddedStress");
        this.failureReason = compound.m_128441_("FailureReason") ? FailureReason.fromId(compound.m_128461_("FailureReason")) : FailureReason.NONE;
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        if (this.boringPos != null) {
            compound.m_128365_("BoringPos", (Tag)NbtUtils.m_129224_((BlockPos)this.boringPos));
        }
        if (!clientPacket) {
            return;
        }
        if (this.addedStressImpact > 0.0f) {
            compound.m_128350_("AddedStress", this.addedStressImpact);
        }
        if (this.boreSpeed != 0.0f) {
            compound.m_128350_("BoreSpeed", this.boreSpeed);
        }
        if (this.failureReason != FailureReason.NONE) {
            compound.m_128359_("FailureReason", this.failureReason.m_7912_());
        }
    }

    @Override
    protected PoleContraption innerAssemble() throws AssemblyException {
        if (!(this.m_58904_().m_8055_(this.f_58858_).m_60734_() instanceof CannonDrillBlock)) {
            return null;
        }
        this.failureReason = FailureReason.NONE;
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)CannonDrillBlock.FACING);
        CannonDrillingContraption contraption = new CannonDrillingContraption(facing, this.getMovementSpeed() < 0.0f);
        if (!contraption.assemble(this.m_58904_(), this.f_58858_)) {
            return null;
        }
        Direction positive = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)facing.m_122434_());
        Direction movementDirection = this.getSpeed() > 0.0f ^ facing.m_122434_() != Direction.Axis.Z ? positive : positive.m_122424_();
        BlockPos anchor = contraption.anchor.m_5484_(facing, contraption.initialExtensionProgress());
        return this.initialCollide(contraption, anchor, movementDirection) ? null : contraption;
    }

    private boolean initialCollide(CannonDrillingContraption contraption, BlockPos anchor, Direction movementDirection) {
        if (ContraptionCollider.isCollidingWithWorld((Level)this.m_58904_(), (TranslatingContraption)contraption, (BlockPos)anchor.m_121945_(movementDirection), (Direction)movementDirection)) {
            return true;
        }
        Vec3 pos = Vec3.m_82528_((Vec3i)anchor.m_121945_(movementDirection));
        BlockPos gridPos = BlockPos.m_274446_((Position)pos);
        AABB bounds = contraption.bounds.m_82383_(pos);
        if (movementDirection.m_122421_() == Direction.AxisDirection.POSITIVE) {
            gridPos = gridPos.m_121945_(movementDirection);
        }
        gridPos = gridPos.m_121945_(movementDirection.m_122424_());
        Direction facing = contraption.orientation();
        Direction positive = Direction.m_122387_((Direction.Axis)facing.m_122434_(), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        Vec3 mask = new Vec3(1.0, 1.0, 1.0).m_82492_((double)positive.m_122429_(), (double)positive.m_122430_(), (double)positive.m_122431_());
        BlockPos maskedPos = BlockPos.m_274446_((Position)pos.m_82559_(mask));
        AABB newBounds = bounds.m_82369_(new Vec3(facing.m_253071_()).m_82490_(128.0)).m_82400_(2.0);
        for (ControlledContraptionEntity other : this.m_58904_().m_6443_(ControlledContraptionEntity.class, newBounds, e -> !e.equals((Object)this.movedContraption))) {
            BlockPos otherMaskedPos;
            Contraption contraption2 = other.getContraption();
            if (!(contraption2 instanceof BearingContraption)) continue;
            BearingContraption lathe = (BearingContraption)contraption2;
            AABB otherBounds = other.m_20191_();
            Direction otherFacing = lathe.getFacing();
            Vec3 otherPosition = other.m_20182_();
            if (other.m_20159_() || otherBounds == null || !bounds.m_82381_(otherBounds) || !maskedPos.equals((Object)(otherMaskedPos = BlockPos.m_274446_((Position)other.getAnchorVec().m_82559_(mask)))) || otherFacing != facing.m_122424_() || movementDirection == otherFacing) continue;
            BlockPos bearingPos = BlockPos.m_274446_((Position)other.getAnchorVec()).m_121945_(facing);
            BlockEntity blockEntity = this.m_58904_().m_7702_(bearingPos);
            if (!(blockEntity instanceof MechanicalBearingBlockEntity)) continue;
            MechanicalBearingBlockEntity bearing = (MechanicalBearingBlockEntity)blockEntity;
            for (BlockPos colliderPos : contraption.getOrCreateColliders(this.m_58904_(), movementDirection)) {
                StructureTemplate.StructureBlockInfo drillBlockInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(colliderPos);
                BlockPos globalPos = colliderPos.m_121955_((Vec3i)gridPos);
                BlockPos otherColliderPos = globalPos.m_121996_((Vec3i)BlockPos.m_274446_((Position)otherPosition));
                if (facing.m_122421_() == Direction.AxisDirection.NEGATIVE) {
                    otherColliderPos = otherColliderPos.m_121945_(facing);
                }
                if (!lathe.getBlocks().containsKey(otherColliderPos) || !CBCBlocks.CANNON_DRILL_BIT.has(drillBlockInfo.f_74676_())) continue;
                StructureTemplate.StructureBlockInfo latheBlockInfo = (StructureTemplate.StructureBlockInfo)lathe.getBlocks().get(otherColliderPos);
                DrillBoringBlockRecipe recipe = AbstractCannonDrillBlockEntity.getBlockRecipe(latheBlockInfo.f_74676_(), facing);
                if (recipe != null) {
                    this.currentRecipe = recipe;
                    return false;
                }
                if (latheBlockInfo.f_74676_().m_204336_(CBCTags.CBCBlockTags.DRILL_CAN_PASS_THROUGH)) continue;
                return true;
            }
        }
        return false;
    }

    public static DrillBoringBlockRecipe getBlockRecipe(BlockState block, Direction dir) {
        return BlockRecipesManager.getRecipesOfType(BlockRecipeType.DRILL_BORING).stream().map(DrillBoringBlockRecipe.class::cast).filter(r -> r.matches(block, dir)).findAny().orElse(null);
    }

    @Override
    public void disassemble() {
        if (!this.running && this.movedContraption == null) {
            return;
        }
        if (!this.f_58859_) {
            this.m_58904_().m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(CannonDrillBlock.STATE, (Comparable)MechanicalPistonBlock.PistonState.EXTENDED), 19);
        }
        super.disassemble();
        if (this.f_58859_) {
            this.f_58857_.m_46796_(2001, this.f_58858_, Block.m_49956_((BlockState)this.m_58900_()));
            this.f_58857_.m_142346_(null, GameEvent.f_157794_, this.f_58858_);
            CannonDrillBlock.destroyExtensionPoles(this.f_58857_, this.f_58858_, this.m_58900_(), true);
        }
    }

    public void tick() {
        if (!this.m_58904_().f_46443_ && this.running && this.movedContraption != null && this.offset + this.getMovementSpeed() >= (float)this.getExtensionRange()) {
            this.collideWithContraptionToBore(null, false);
        }
        super.tick();
    }

    public void lazyTick() {
        if (!this.f_58857_.f_46443_) {
            this.sendData();
        }
    }

    protected boolean moveAndCollideContraption() {
        if (super.moveAndCollideContraption()) {
            this.collideWithContraptionToBore(null, true);
            this.boreSpeed = 0.0f;
            this.addedStressImpact = 0.0f;
            this.latheEntity = null;
            return true;
        }
        return false;
    }

    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.boreSpeed = 0.0f;
        this.addedStressImpact = 0.0f;
        this.latheEntity = null;
        this.failureReason = FailureReason.NONE;
    }

    public boolean collideWithContraptionToBore(ControlledContraptionEntity other, boolean collide) {
        Contraption contraption;
        Direction movementDirection;
        if (this.m_58904_().f_46443_) {
            return false;
        }
        if (other == null && this.latheEntity == null) {
            return false;
        }
        CannonDrillingContraption drill = (CannonDrillingContraption)this.movedContraption.getContraption();
        AABB bounds = this.movedContraption.m_20191_();
        Vec3 pos = this.movedContraption.m_20182_();
        BlockPos gridPos = BlockPos.m_274446_((Position)pos);
        Vec3 motion = this.movedContraption.m_20184_();
        if (drill == null || bounds == null) {
            return false;
        }
        Direction facing = drill.orientation();
        Direction positive = Direction.m_122387_((Direction.Axis)facing.m_122434_(), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        Vec3 mask = new Vec3(1.0, 1.0, 1.0).m_82492_((double)positive.m_122429_(), (double)positive.m_122430_(), (double)positive.m_122431_());
        BlockPos maskedPos = BlockPos.m_274446_((Position)pos.m_82559_(mask));
        Direction direction = movementDirection = collide ? drill.orientation() : Direction.m_122366_((double)motion.f_82479_, (double)motion.f_82480_, (double)motion.f_82481_);
        if (!collide && movementDirection.m_122421_() == Direction.AxisDirection.POSITIVE) {
            gridPos = gridPos.m_121945_(movementDirection);
        }
        if (collide && movementDirection.m_122421_() == Direction.AxisDirection.NEGATIVE) {
            gridPos = gridPos.m_121945_(movementDirection.m_122424_());
        }
        boolean isBoringBlock = false;
        if (this.latheEntity == null) {
            this.latheEntity = other;
        }
        if (!((contraption = this.latheEntity.getContraption()) instanceof BearingContraption)) {
            this.stopBoringState();
            return false;
        }
        BearingContraption lathe = (BearingContraption)contraption;
        AABB otherBounds = this.latheEntity.m_20191_();
        Direction otherFacing = lathe.getFacing();
        Vec3 otherPosition = this.latheEntity.m_20182_();
        if (this.latheEntity.m_20159_() || otherBounds == null || !bounds.m_82383_(motion).m_82381_(otherBounds)) {
            this.stopBoringState();
            return false;
        }
        BlockPos otherMaskedPos = BlockPos.m_274446_((Position)this.latheEntity.getAnchorVec().m_82559_(mask));
        if (!maskedPos.equals((Object)otherMaskedPos) || otherFacing != facing.m_122424_() || movementDirection == otherFacing) {
            this.stopBoringState();
            return false;
        }
        BlockPos bearingPos = BlockPos.m_274446_((Position)this.latheEntity.getAnchorVec()).m_121945_(facing);
        BlockEntity blockEntity = this.m_58904_().m_7702_(bearingPos);
        if (!(blockEntity instanceof MechanicalBearingBlockEntity)) {
            this.stopBoringState();
            return false;
        }
        MechanicalBearingBlockEntity bearing = (MechanicalBearingBlockEntity)blockEntity;
        for (BlockPos colliderPos : drill.getOrCreateColliders(this.m_58904_(), movementDirection)) {
            float f;
            Block block;
            BlockPos currentPos;
            StructureTemplate.StructureBlockInfo drillBlockInfo = (StructureTemplate.StructureBlockInfo)drill.getBlocks().get(colliderPos);
            BlockPos globalPos = colliderPos.m_121955_((Vec3i)gridPos);
            BlockPos otherColliderPos = globalPos.m_121996_((Vec3i)BlockPos.m_274446_((Position)otherPosition));
            if (!lathe.getBlocks().containsKey(otherColliderPos) || !CBCBlocks.CANNON_DRILL_BIT.has(drillBlockInfo.f_74676_())) continue;
            StructureTemplate.StructureBlockInfo latheBlockInfo = (StructureTemplate.StructureBlockInfo)lathe.getBlocks().get(otherColliderPos);
            BlockPos blockPos = currentPos = collide || this.offset + this.getMovementSpeed() >= (float)this.getExtensionRange() ? globalPos.m_121945_(movementDirection) : globalPos;
            if (this.boringPos == null) {
                this.boringPos = currentPos;
            } else if (!this.boringPos.equals((Object)currentPos)) {
                this.tryFinishingBoring();
                this.boringPos = currentPos;
            }
            DrillBoringBlockRecipe candidate = AbstractCannonDrillBlockEntity.getBlockRecipe(latheBlockInfo.f_74676_(), facing);
            if (candidate == null) {
                if (latheBlockInfo.f_74676_().m_204336_(CBCTags.CBCBlockTags.DRILL_CAN_PASS_THROUGH)) continue;
                this.stopBoringState();
                this.simulateStop();
                return true;
            }
            this.currentRecipe = candidate;
            int drainSpeed = (int)Mth.m_14154_((float)(bearing.getSpeed() * 0.5f));
            if (Math.abs(bearing.getSpeed()) > Math.abs(this.getSpeed())) {
                this.failureReason = FailureReason.TOO_WEAK;
            } else if (this.drainLubricant(drainSpeed)) {
                boolean start;
                boolean bl = start = this.failureReason == FailureReason.NONE;
                if (start) {
                    this.m_58904_().m_5594_(null, globalPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 2.0f);
                }
                if ((start || this.m_58904_().m_46467_() % 3L == 0L) && (block = this.m_58904_()) instanceof ServerLevel) {
                    ServerLevel slevel = (ServerLevel)block;
                    Vec3 particlePos = Vec3.m_82512_((Vec3i)globalPos).m_82492_((double)facing.m_122429_() * 0.5, (double)facing.m_122430_() * 0.5, (double)facing.m_122431_() * 0.5);
                    slevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 10, 0.0, 0.0, 0.0, 0.02);
                }
                this.failureReason = FailureReason.DRY_BORE;
            }
            if (this.failureReason != FailureReason.NONE) {
                if (this.boreSpeed != 0.0f) {
                    this.offset = (int)this.offset;
                    if (!this.boringPos.equals((Object)globalPos)) {
                        this.offset -= 1.0f;
                    }
                }
                this.stopBoringState();
                return true;
            }
            this.failureReason = FailureReason.NONE;
            isBoringBlock = true;
            block = latheBlockInfo.f_74676_().m_60734_();
            if (block instanceof BigCannonBlock) {
                BigCannonBlock cBlock = (BigCannonBlock)block;
                f = cBlock.getCannonMaterial().properties().weight();
            } else {
                f = 1.0f;
            }
            float weight = f;
            this.boreSpeed = bearing.getAngularSpeed() / 512.0f / (weight == 0.0f ? 1.0f : weight);
            float fSpeed = Math.abs(this.boreSpeed);
            this.boreSpeed = fSpeed * Math.signum(this.getSpeed());
            this.addedStressImpact = weight;
            if (this.m_58904_().m_46467_() % 4L == 0L) {
                this.m_58904_().m_5594_(null, globalPos, SoundEvents.f_11998_, SoundSource.BLOCKS, 1.0f, Math.min(Math.abs(bearing.getSpeed()) / 128.0f, 2.0f));
            }
            this.notifyUpdate();
            break;
        }
        if (!isBoringBlock) {
            this.stopBoringState();
        }
        return true;
    }

    protected abstract boolean drainLubricant(int var1);

    protected void stopBoringState() {
        this.boringPos = null;
        this.boreSpeed = 0.0f;
        this.addedStressImpact = 0.0f;
        this.latheEntity = null;
    }

    protected void simulateStop() {
        this.movedContraption.setContraptionMotion(Vec3.f_82478_);
        this.offset = this.getGridOffset(this.offset);
        this.resetContraptionToOffset();
        this.collided();
    }

    protected void tryFinishingBoring() {
        Object cBlock;
        Block block;
        BearingContraption lathe;
        ServerLevel slevel;
        block16: {
            block15: {
                block14: {
                    block13: {
                        Level level = this.m_58904_();
                        if (!(level instanceof ServerLevel)) break block13;
                        slevel = (ServerLevel)level;
                        if (this.latheEntity != null && this.movedContraption != null && this.boringPos != null && this.currentRecipe != null) break block14;
                    }
                    return;
                }
                Contraption contraption = this.latheEntity.getContraption();
                if (!(contraption instanceof BearingContraption)) break block15;
                lathe = (BearingContraption)contraption;
                if (!lathe.stalled) break block16;
            }
            return;
        }
        BlockPos boringOffset = this.boringPos.m_121996_((Vec3i)BlockPos.m_274446_((Position)this.latheEntity.m_20182_()));
        if (!lathe.getBlocks().containsKey(boringOffset)) {
            return;
        }
        StructureTemplate.StructureBlockInfo latheBlockInfo = (StructureTemplate.StructureBlockInfo)lathe.getBlocks().get(boringOffset);
        Direction facing = ((CannonDrillingContraption)this.movedContraption.getContraption()).orientation();
        BlockState boredState = this.currentRecipe.getResultState(latheBlockInfo.f_74676_());
        if (latheBlockInfo.f_74677_() != null && (block = boredState.m_60734_()) instanceof IBE) {
            IBE boredBE = (IBE)block;
            BlockEntity be = boredBE.m_142194_(BlockPos.f_121853_, boredState);
            latheBlockInfo.f_74677_().m_128379_("JustBored", true);
            Block block2 = boredState.m_60734_();
            if (block2 instanceof BigCannonBlock) {
                cBlock = (BigCannonBlock)block2;
                if (be instanceof LayeredBigCannonBlockEntity) {
                    ICannonBlockEntity cbe2;
                    LayeredBigCannonBlockEntity layered2;
                    BlockEntity be2;
                    StructureTemplate.StructureBlockInfo prevBlockInfo;
                    ICannonBlockEntity cbe1;
                    LayeredBigCannonBlockEntity layered1;
                    BlockEntity be1;
                    LayeredBigCannonBlockEntity layered = (LayeredBigCannonBlockEntity)be;
                    CannonCastShape shape = cBlock.getCannonShape();
                    CompoundTag layerConnectionsTag = new CompoundTag();
                    Direction opp = facing.m_122424_();
                    StructureTemplate.StructureBlockInfo nextBlockInfo = (StructureTemplate.StructureBlockInfo)lathe.getBlocks().get(boringOffset.m_121945_(facing));
                    if (nextBlockInfo != null && nextBlockInfo.f_74677_() != null && ((be1 = BlockEntity.m_155241_((BlockPos)BlockPos.f_121853_, (BlockState)nextBlockInfo.f_74676_(), (CompoundTag)nextBlockInfo.f_74677_())) instanceof LayeredBigCannonBlockEntity && (layered1 = (LayeredBigCannonBlockEntity)be1).isLayerConnectedTo(opp, shape) || be1 instanceof ICannonBlockEntity && ((CannonBehavior)((Object)(cbe1 = (ICannonBlockEntity)be1).cannonBehavior())).isConnectedTo(opp))) {
                        ResourceLocation key = CBCRegistries.cannonCastShapes().m_7981_((Object)cBlock.getCannonShape());
                        ListTag list = new ListTag();
                        list.add((Object)StringTag.m_129297_((String)key.toString()));
                        layerConnectionsTag.m_128365_(facing.m_7912_(), (Tag)list);
                    }
                    if ((prevBlockInfo = (StructureTemplate.StructureBlockInfo)lathe.getBlocks().get(boringOffset.m_121945_(opp))) != null && prevBlockInfo.f_74677_() != null && ((be2 = BlockEntity.m_155241_((BlockPos)BlockPos.f_121853_, (BlockState)prevBlockInfo.f_74676_(), (CompoundTag)prevBlockInfo.f_74677_())) instanceof LayeredBigCannonBlockEntity && (layered2 = (LayeredBigCannonBlockEntity)be2).isLayerConnectedTo(facing, shape) || be2 instanceof ICannonBlockEntity && ((CannonBehavior)((Object)(cbe2 = (ICannonBlockEntity)be2).cannonBehavior())).isConnectedTo(facing))) {
                        ResourceLocation key = CBCRegistries.cannonCastShapes().m_7981_((Object)cBlock.getCannonShape());
                        ListTag list = new ListTag();
                        list.add((Object)StringTag.m_129297_((String)key.toString()));
                        layerConnectionsTag.m_128365_(opp.m_7912_(), (Tag)list);
                    }
                    latheBlockInfo.f_74677_().m_128365_("LayerConnections", (Tag)layerConnectionsTag);
                }
            }
        }
        BlockPos bearingPos = BlockPos.m_274446_((Position)this.latheEntity.getAnchorVec()).m_121945_(facing);
        cBlock = this.m_58904_().m_7702_(bearingPos);
        if (!(cBlock instanceof MechanicalBearingBlockEntity)) {
            return;
        }
        MechanicalBearingBlockEntity bearing = (MechanicalBearingBlockEntity)cBlock;
        StructureTemplate.StructureBlockInfo newInfo = new StructureTemplate.StructureBlockInfo(boringOffset, boredState, latheBlockInfo.f_74677_());
        lathe.getBlocks().put(boringOffset, newInfo);
        bearing.notifyUpdate();
        ResourceLocation unboredId = CBCRegistryUtils.getBlockLocation(latheBlockInfo.f_74676_().m_60734_());
        LootTable table = slevel.m_7654_().m_278653_().m_278676_(CBCUtils.location(unboredId.m_135827_(), "boring_scrap/" + unboredId.m_135815_()));
        ObjectArrayList scrap = table.m_287195_(new LootParams.Builder(slevel).m_287286_(LootContextParams.f_81461_, (Object)latheBlockInfo.f_74676_()).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.boringPos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287235_(LootContextParamSets.f_81421_));
        scrap.forEach(s -> Block.m_49840_((Level)this.m_58904_(), (BlockPos)this.boringPos, (ItemStack)s));
        this.m_58904_().m_5594_(null, this.boringPos, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
        NetworkPlatform.sendToClientTracking(new ClientboundUpdateContraptionPacket(this.latheEntity, boringOffset, newInfo), (Entity)this.latheEntity);
        this.boringPos = null;
    }

    public float calculateStressApplied() {
        this.lastStressApplied = super.calculateStressApplied() + this.addedStressImpact;
        return this.lastStressApplied;
    }

    @Override
    public float getMovementSpeed() {
        float movementSpeed;
        float f = this.failureReason != FailureReason.NONE ? 0.0f : (movementSpeed = Mth.m_14036_((float)(this.boreSpeed != 0.0f ? this.boreSpeed : AbstractCannonDrillBlockEntity.convertToLinear((float)this.getSpeed())), (float)-0.49f, (float)0.49f));
        if (this.m_58904_().f_46443_) {
            movementSpeed *= ServerSpeedProvider.get();
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)CannonDrillBlock.FACING);
        int movementModifier = facing.m_122421_().m_122540_() * (facing.m_122434_() == Direction.Axis.Z ? -1 : 1);
        movementSpeed = movementSpeed * (float)(-movementModifier) + this.clientOffsetDiff * 0.5f;
        movementSpeed = Mth.m_14036_((float)movementSpeed, (float)(0.0f - this.offset), (float)((float)this.extensionLength - this.offset));
        if (this.sequencedOffsetLimit >= 0.0) {
            movementSpeed = (float)Mth.m_14008_((double)movementSpeed, (double)(-this.sequencedOffsetLimit), (double)this.sequencedOffsetLimit);
        }
        return movementSpeed;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        tooltip.add((Component)Component.m_237119_());
        this.addFluidInfoToTooltip(tooltip, isPlayerSneaking);
        if (this.failureReason != FailureReason.NONE) {
            tooltip.add((Component)Component.m_237119_());
            Lang.builder((String)"exception").translate("createbigcannons.cannon_drill.tooltip.encounteredProblem", new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip);
            MutableComponent exceptionText = Lang.builder((String)"exception").translate("createbigcannons.cannon_drill.tooltip." + this.failureReason.m_7912_(), new Object[0]).component();
            tooltip.addAll(TooltipHelper.cutTextComponent((Component)exceptionText, (Style)TooltipHelper.Palette.GRAY_AND_WHITE.primary(), (Style)TooltipHelper.Palette.GRAY_AND_WHITE.highlight(), (int)4));
        }
        return true;
    }

    protected abstract void addFluidInfoToTooltip(List<Component> var1, boolean var2);

    public static enum FailureReason implements StringRepresentable
    {
        DRY_BORE("dryBore"),
        TOO_WEAK("tooWeak"),
        NONE("none");

        private static final Map<String, FailureReason> BY_ID;
        private final String id;

        private FailureReason(String id) {
            this.id = id;
        }

        public String m_7912_() {
            return this.id;
        }

        public static FailureReason fromId(String id) {
            return BY_ID.getOrDefault(id, DRY_BORE);
        }

        static {
            BY_ID = Arrays.stream(FailureReason.values()).collect(Collectors.toMap(FailureReason::m_7912_, Function.identity()));
        }
    }
}

