/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.block_hit_effects.BlockImpactTransformationHandler;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.network.ClientboundCBCExplodePacket;
import rbasamoyai.createbigcannons.remix.CustomExplosion;
import rbasamoyai.ritchiesprojectilelib.effects.screen_shake.ScreenShakeEffect;

public class ImpactExplosion
extends CustomExplosion.Impl {
    private final Set<BlockPos> changedBlocks = new HashSet<BlockPos>();

    public ImpactExplosion(Level level, @Nullable Entity source, @Nullable DamageSource damageSource, double toBlowX, double toBlowY, double toBlowZ, float radius, Level.ExplosionInteraction interaction) {
        super(level, source, damageSource, null, toBlowX, toBlowY, toBlowZ, radius, false, interaction);
    }

    public ImpactExplosion(Level level, ClientboundCBCExplodePacket packet) {
        super(level, packet);
    }

    @Override
    public void editBlock(Level level, BlockPos pos, BlockState blockState, FluidState fluidState, float power) {
        if (!((Boolean)CBCConfigs.SERVER.munitions.projectilesChangeSurroundings.get()).booleanValue() || this.changedBlocks.contains(pos)) {
            return;
        }
        BlockState transformed = BlockImpactTransformationHandler.transformBlock(blockState);
        level.m_7731_(pos, transformed, 11);
        this.changedBlocks.add(pos);
    }

    @Override
    public void sendExplosionToClient(ServerPlayer player) {
        double distSqr = player.m_20275_(this.x, this.y, this.z);
        if (distSqr < 10000.0) {
            float f = Math.max(1.0f - (float)distSqr / 100.0f, 0.0f);
            float f1 = this.size * f;
            float shake = Math.min(45.0f, f1 * 4.0f);
            CreateBigCannons.shakePlayerScreen(player, new ScreenShakeEffect(0, shake, shake * 0.5f, shake * 0.5f, 1.0f, 1.0f, 1.0f, this.x, this.y, this.z));
            Vec3 knockback = this.m_46078_().getOrDefault(player, Vec3.f_82478_);
            NetworkPlatform.sendToClientPlayer(new ClientboundCBCExplodePacket(this.x, this.y, this.z, this.size, this.m_46081_(), (float)knockback.f_82479_, (float)knockback.f_82480_, (float)knockback.f_82481_, ClientboundCBCExplodePacket.ExplosionType.IMPACT), player);
        }
    }
}

