/*
 * Decompiled with CFR 0.152.
 */
package com.ibarnstormer.gbd.network;

import com.ibarnstormer.gbd.event.ModEvents;
import com.ibarnstormer.gbd.network.IModPacket;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class BeamReactorRayTracePacket
implements IModPacket {
    double rayX;
    double rayY;
    double rayZ;

    public BeamReactorRayTracePacket(Vec3 ray) {
        this.rayX = ray.f_82479_;
        this.rayY = ray.f_82480_;
        this.rayZ = ray.f_82481_;
    }

    public BeamReactorRayTracePacket(FriendlyByteBuf buf) {
        this.rayX = buf.readDouble();
        this.rayY = buf.readDouble();
        this.rayZ = buf.readDouble();
    }

    @Override
    public void send(FriendlyByteBuf buf) {
        buf.writeDouble(this.rayX);
        buf.writeDouble(this.rayY);
        buf.writeDouble(this.rayZ);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                ModEvents.handleBeam((Player)player, new Vec3(this.rayX, this.rayY, this.rayZ));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

