/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.create_interactive;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.utility.Color;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.valkyrienskies.create_interactive.CreateInteractiveMod;
import org.valkyrienskies.create_interactive.services.NoOptimize;

public final class CreateInteractiveIcons
extends AllIcons {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int x;
    private int y;
    private int iconX;
    private int iconY;
    @NotNull
    private static final CreateInteractiveIcons INSTANCE = new CreateInteractiveIcons(0, -1);
    @NotNull
    private static final ResourceLocation ICON_ATLAS = CreateInteractiveMod.INSTANCE.asResource("textures/gui/icons.png");
    private static final int ICON_ATLAS_SIZE = 256;
    @NotNull
    private static final CreateInteractiveIcons I_COMEDY = INSTANCE.newRow();
    @NotNull
    private static final CreateInteractiveIcons I_TRAGEDY = INSTANCE.next();

    public CreateInteractiveIcons(int x, int y) {
        super(x, y);
        this.x = x;
        this.y = y;
        this.iconX = this.x * 16;
        this.iconY = this.y * 16;
    }

    public final int getX() {
        return this.x;
    }

    public final void setX(int n) {
        this.x = n;
    }

    public final int getY() {
        return this.y;
    }

    public final void setY(int n) {
        this.y = n;
    }

    private final CreateInteractiveIcons next() {
        ++this.x;
        return new CreateInteractiveIcons(this.x, this.y);
    }

    private final CreateInteractiveIcons newRow() {
        int n;
        int it = n = 0;
        boolean bl = false;
        this.x = 0;
        ++this.y;
        int n2 = this.y;
        int n3 = n;
        return new CreateInteractiveIcons(n3, n2);
    }

    @OnlyIn(value=Dist.CLIENT)
    @NoOptimize
    public void bind() {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICON_ATLAS);
    }

    @OnlyIn(value=Dist.CLIENT)
    @NoOptimize
    public void render(@NotNull GuiGraphics graphics, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        this.bind();
        graphics.m_280398_(AllIcons.ICON_ATLAS, x, y, 0, (float)this.iconX, (float)this.iconY, 16, 16, 256, 256);
    }

    @OnlyIn(value=Dist.CLIENT)
    @NoOptimize
    public void render(@NotNull PoseStack ms, @NotNull MultiBufferSource buffer, int color) {
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110497_((ResourceLocation)ICON_ATLAS));
        Matrix4f matrix = ms.m_85850_().m_252922_();
        Color rgb = new Color(color);
        int light = 0xF000F0;
        Vec3 vec1 = new Vec3(0.0, 0.0, 0.0);
        Vec3 vec2 = new Vec3(0.0, 1.0, 0.0);
        Vec3 vec3 = new Vec3(1.0, 1.0, 0.0);
        Vec3 vec4 = new Vec3(1.0, 0.0, 0.0);
        float u1 = (float)this.iconX * 1.0f / (float)256;
        float u2 = (float)(this.iconX + 16) * 1.0f / (float)256;
        float v1 = (float)this.iconY * 1.0f / (float)256;
        float v2 = (float)(this.iconY + 16) * 1.0f / (float)256;
        Intrinsics.checkNotNull((Object)builder);
        Intrinsics.checkNotNull((Object)matrix);
        this.vertex(builder, matrix, vec1, rgb, u1, v1, light);
        this.vertex(builder, matrix, vec2, rgb, u1, v2, light);
        this.vertex(builder, matrix, vec3, rgb, u2, v2, light);
        this.vertex(builder, matrix, vec4, rgb, u2, v1, light);
    }

    @OnlyIn(value=Dist.CLIENT)
    private final void vertex(VertexConsumer builder, Matrix4f matrix, Vec3 vec, Color rgb, float u, float v, int light) {
        builder.m_252986_(matrix, (float)vec.f_82479_, (float)vec.f_82480_, (float)vec.f_82481_).m_6122_(rgb.getRed(), rgb.getGreen(), rgb.getBlue(), 255).m_7421_(u, v).m_85969_(light).m_5752_();
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CreateInteractiveIcons getI_COMEDY() {
            return I_COMEDY;
        }

        @NotNull
        public final CreateInteractiveIcons getI_TRAGEDY() {
            return I_TRAGEDY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

