/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.create_interactive.content.mechanical_propagator;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.IControlContraption;
import com.simibubi.create.content.contraptions.bearing.BearingBlock;
import com.simibubi.create.content.contraptions.bearing.BearingContraption;
import com.simibubi.create.content.contraptions.bearing.MechanicalBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.transmission.sequencer.SequencerInstructions;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3ic;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.create_interactive.CreateInteractiveUtil;
import org.valkyrienskies.create_interactive.mixin.GeneratingKineticBlockEntityAccessor;
import org.valkyrienskies.create_interactive.mixin.KineticBlockEntityAccessor;
import org.valkyrienskies.create_interactive.mixin.MechanicalBearingBlockEntityAccessor;
import org.valkyrienskies.create_interactive.mixin.SmartBlockEntityAccessor;
import org.valkyrienskies.create_interactive.mixinducks.AbstractContraptionEntityDuck;
import org.valkyrienskies.create_interactive.services.NoOptimize;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public final class DisjointedPropagatorBearingBlockEntity
extends MechanicalBearingBlockEntity {
    private float disjointAngle;
    private float disjointSpeed;
    private float prevDisjointAngle;
    private float prevDisjointSpeed;
    private boolean shouldUpdateDestinationConnections;
    @Nullable
    private BlockEntity previousOtherConnection;

    public DisjointedPropagatorBearingBlockEntity(@NotNull BlockEntityType<? extends DisjointedPropagatorBearingBlockEntity> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        this.shouldUpdateDestinationConnections = true;
    }

    private final BlockPos getOtherConnection() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            return null;
        }
        ControlledContraptionEntity controlledContraptionEntity = this.movedContraption;
        if (controlledContraptionEntity == null) {
            return null;
        }
        ControlledContraptionEntity contraption = controlledContraptionEntity;
        Long l = ((AbstractContraptionEntityDuck)contraption).ci$getShadowShipId();
        if (l == null) {
            return null;
        }
        long shipId = ((Number)l).longValue();
        Ship ship = VSGameUtilsKt.getShipObjectWorld((Level)this.f_58857_).getAllShips().getById(shipId);
        if (ship == null) {
            return null;
        }
        Ship ship2 = ship;
        Level level2 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level2);
        return VectorConversionsMCKt.toBlockPos((Vector3ic)CreateInteractiveUtil.INSTANCE.getChunkClaimCenterPos(ship2, level2));
    }

    public final float getDisjointInterpolatedAngle(float partialTicks) {
        float partialTicks2 = partialTicks;
        if (this.isVirtual()) {
            return Mth.m_14179_((float)(partialTicks2 + 0.5f), (float)this.prevDisjointAngle, (float)this.disjointAngle);
        }
        if (this.movedContraption == null || this.movedContraption.isStalled() || !this.running) {
            partialTicks2 = 0.0f;
        }
        float angularSpeed = this.getDisjointAngularSpeed();
        if (this.sequencedAngleLimit >= 0.0) {
            angularSpeed = (float)Mth.m_14008_((double)angularSpeed, (double)(-this.sequencedAngleLimit), (double)this.sequencedAngleLimit);
        }
        return Mth.m_14179_((float)partialTicks2, (float)this.disjointAngle, (float)(this.disjointAngle + angularSpeed));
    }

    private final float getDisjointAngularSpeed() {
        float speed = MechanicalBearingBlockEntity.convertToAngular((float)(this.isWindmill() ? this.getGeneratedSpeed() : this.disjointSpeed));
        if (this.disjointSpeed == 0.0f) {
            speed = 0.0f;
        }
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            speed *= ServerSpeedProvider.get();
            speed += this.clientAngleDiff / 3.0f;
        }
        return speed;
    }

    @NoOptimize
    public void write(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.write(compound, clientPacket);
        compound.m_128350_("DisjointAngle", this.disjointAngle);
        compound.m_128350_("DisjointSpeed", this.disjointSpeed);
    }

    @NoOptimize
    protected void read(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        this.disjointAngle = compound.m_128457_("DisjointAngle");
        this.disjointSpeed = compound.m_128457_("DisjointSpeed");
        super.read(compound, clientPacket);
    }

    @NoOptimize
    @NotNull
    public List<BlockPos> addPropagationLocations(@NotNull IRotate block, @Nullable BlockState state, @NotNull List<BlockPos> neighbours) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter(neighbours, (String)"neighbours");
        List locations = super.addPropagationLocations(block, state, neighbours);
        if (this.getOtherConnection() != null) {
            locations.add(this.getOtherConnection());
        }
        Intrinsics.checkNotNull((Object)locations);
        return locations;
    }

    @NoOptimize
    public float propagateRotationTo(@NotNull KineticBlockEntity target, @Nullable BlockState stateFrom, @Nullable BlockState stateTo, @Nullable BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (Intrinsics.areEqual((Object)target.m_58899_(), (Object)this.getOtherConnection())) {
            BlockState blockState = stateTo;
            Intrinsics.checkNotNull((Object)blockState);
            Block toBlock = blockState.m_60734_();
            if (!(toBlock instanceof IRotate)) {
                return 0.0f;
            }
            Direction direction = ((Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)).m_122424_();
            if (!((IRotate)toBlock).hasShaftTowards((LevelReader)target.m_58904_(), target.m_58899_(), target.m_58900_(), direction)) {
                return 0.0f;
            }
            return 1.0f;
        }
        return 0.0f;
    }

    @NoOptimize
    protected void applyRotation() {
        if (this.movedContraption == null) {
            return;
        }
        this.movedContraption.setAngle(this.disjointAngle);
        BlockState blockState = this.m_58900_();
        if (blockState.m_61138_((Property)BlockStateProperties.f_61372_)) {
            this.movedContraption.setRotationAxis(((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_());
        }
    }

    @NoOptimize
    public void onSpeedChanged(float prevSpeed) {
        this.m_6596_();
    }

    @NoOptimize
    public void tick() {
        Intrinsics.checkNotNull((Object)((Object)this), (String)"null cannot be cast to non-null type org.valkyrienskies.create_interactive.mixin.SmartBlockEntityAccessor");
        SmartBlockEntityAccessor smartAccess = (SmartBlockEntityAccessor)((Object)this);
        KineticBlockEntityAccessor kineticSmartAccess = (KineticBlockEntityAccessor)((Object)this);
        MechanicalBearingBlockEntityAccessor mechAccess = (MechanicalBearingBlockEntityAccessor)((Object)this);
        if (!smartAccess.getInitialized() && this.m_58898_()) {
            this.initialize();
            smartAccess.setInitialized(true);
        }
        int n = smartAccess.getLazyTickCounter();
        smartAccess.setLazyTickCounter(n + -1);
        if (n <= 0) {
            smartAccess.setLazyTickCounter(smartAccess.getLazyTickRate());
            this.lazyTick();
        }
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (!level.f_46443_ && this.needsSpeedUpdate()) {
            this.attachKinetics();
        }
        this.effects.tick();
        kineticSmartAccess.setPreventSpeedUpdate(0);
        Level level2 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level2);
        if (level2.f_46443_) {
            this.tickAudio();
        } else {
            KineticBlockEntityAccessor kinetAccess = (KineticBlockEntityAccessor)((KineticBlockEntity)this);
            int n2 = kinetAccess.getValidationCountdown();
            kinetAccess.setValidationCountdown(n2 + -1);
            if (n2 <= 0) {
                Object object = AllConfigs.server().kinetics.kineticValidationFrequency.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                kinetAccess.setValidationCountdown(((Number)object).intValue());
                kinetAccess.invokeValidateKinetics();
            }
            if (this.getFlickerScore() > 0) {
                kinetAccess.setFlickerTally(this.getFlickerScore() - 1);
            }
            if (kineticSmartAccess.getNetworkDirty()) {
                if (this.hasNetwork()) {
                    this.getOrCreateNetwork().updateNetwork();
                }
                kineticSmartAccess.setNetworkDirty(false);
            }
            this.forEachBehaviour(DisjointedPropagatorBearingBlockEntity::tick$lambda$0);
        }
        GeneratingKineticBlockEntityAccessor generatingAccess = (GeneratingKineticBlockEntityAccessor)((Object)this);
        if (generatingAccess.getReActivateSource()) {
            this.updateGeneratedRotation();
            generatingAccess.setReActivateSource(false);
        }
        BlockPos pos = this.m_58899_().m_5484_(((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_(), 1);
        this.prevDisjointSpeed = this.disjointSpeed;
        this.prevDisjointAngle = this.disjointAngle;
        Level level3 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level3);
        BlockEntity blockEntity = level3.m_7702_(pos);
        if (blockEntity != null) {
            BlockState state;
            Block block;
            if (blockEntity instanceof KineticBlockEntity && (block = (state = ((KineticBlockEntity)blockEntity).m_58900_()).m_60734_()) instanceof IRotate && ((IRotate)block).hasShaftTowards((LevelReader)this.f_58857_, pos, state, (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_))) {
                this.disjointSpeed = ((KineticBlockEntity)blockEntity).getSpeed();
                mechAccess.setAssembleNextTick(true);
                mechAccess.setSequencedAngleLimit(-1.0);
                if (this.movedContraption != null && !(Math.signum(this.prevDisjointSpeed) == Math.signum(this.getSpeed())) && !(this.prevDisjointSpeed == 0.0f)) {
                    if (!this.movedContraption.isStalled()) {
                        mechAccess.setAngle(Math.round(mechAccess.getAngle()));
                        this.applyRotation();
                    }
                    this.movedContraption.getContraption().stop(this.f_58857_);
                }
                if (!this.isWindmill() && kineticSmartAccess.getSequenceContext() != null && kineticSmartAccess.getSequenceContext().instruction() == SequencerInstructions.TURN_ANGLE) {
                    mechAccess.setSequencedAngleLimit(kineticSmartAccess.getSequenceContext().getEffectiveValue((double)this.getTheoreticalSpeed()));
                }
                this.m_6596_();
            }
        } else {
            this.disjointSpeed = 0.0f;
            mechAccess.setAssembleNextTick(true);
            mechAccess.setSequencedAngleLimit(-1.0);
            if (this.movedContraption != null && !(Math.signum(this.prevDisjointSpeed) == Math.signum(this.getSpeed())) && !(this.prevDisjointSpeed == 0.0f)) {
                if (!this.movedContraption.isStalled()) {
                    mechAccess.setAngle(Math.round(mechAccess.getAngle()));
                    this.applyRotation();
                }
                this.movedContraption.getContraption().stop(this.f_58857_);
            }
            if (!this.isWindmill() && kineticSmartAccess.getSequenceContext() != null && kineticSmartAccess.getSequenceContext().instruction() == SequencerInstructions.TURN_ANGLE) {
                mechAccess.setSequencedAngleLimit(kineticSmartAccess.getSequenceContext().getEffectiveValue((double)this.getTheoreticalSpeed()));
            }
            this.m_6596_();
        }
        Level level4 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level4);
        if (level4.f_46443_) {
            mechAccess.setClientAngleDiff(mechAccess.getClientAngleDiff() / 2.0f);
        }
        Level level5 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level5);
        if (!level5.f_46443_ && mechAccess.getAssembleNextTick()) {
            mechAccess.setAssembleNextTick(false);
            if (this.running) {
                boolean canDisassemble = mechAccess.getMovementMode().get() == IControlContraption.RotationMode.ROTATE_PLACE || this.isNearInitialAngle() && mechAccess.getMovementMode().get() == IControlContraption.RotationMode.ROTATE_PLACE_RETURNED;
                if (this.disjointSpeed == 0.0f && (canDisassemble || this.movedContraption == null || this.movedContraption.getContraption().getBlocks().isEmpty())) {
                    if (this.movedContraption != null) {
                        this.movedContraption.getContraption().stop(this.f_58857_);
                    }
                    this.disassemble();
                    return;
                }
            } else {
                if (this.disjointSpeed == 0.0f && !this.isWindmill()) {
                    return;
                }
                this.assemble();
            }
        }
        if (!this.running) {
            return;
        }
        if (this.movedContraption == null || !this.movedContraption.isStalled()) {
            float angularSpeed = this.getDisjointAngularSpeed();
            if (mechAccess.getSequencedAngleLimit() >= 0.0) {
                angularSpeed = (float)Mth.m_14008_((double)angularSpeed, (double)(-mechAccess.getSequencedAngleLimit()), (double)mechAccess.getSequencedAngleLimit());
                mechAccess.setSequencedAngleLimit(RangesKt.coerceAtLeast((double)0.0, (double)(mechAccess.getSequencedAngleLimit() - (double)Math.abs(angularSpeed))));
            }
            float newAngle = this.disjointAngle + angularSpeed;
            this.disjointAngle = newAngle % (float)360;
        }
        this.applyRotation();
    }

    @NoOptimize
    public void assemble() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (!(level.m_8055_(this.f_58858_).m_60734_() instanceof BearingBlock)) {
            return;
        }
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)BearingBlock.FACING);
        BearingContraption contraption = new BearingContraption(this.isWindmill(), direction);
        try {
            if (!contraption.assemble(this.f_58857_, this.f_58858_)) {
                return;
            }
            this.lastException = null;
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return;
        }
        if (this.isWindmill()) {
            this.award(AllAdvancements.WINDMILL);
        }
        if (contraption.getSailBlocks() >= 128) {
            this.award(AllAdvancements.WINDMILL_MAXED);
        }
        contraption.removeBlocksFromWorld(this.f_58857_, BlockPos.f_121853_);
        this.movedContraption = ControlledContraptionEntity.create((Level)this.f_58857_, (IControlContraption)((IControlContraption)this), (Contraption)((Contraption)contraption));
        BlockPos anchor = this.f_58858_.m_121945_(direction);
        this.movedContraption.m_6034_((double)anchor.m_123341_(), (double)anchor.m_123342_(), (double)anchor.m_123343_());
        this.movedContraption.setRotationAxis(direction.m_122434_());
        Level level2 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level2);
        level2.m_7967_((Entity)this.movedContraption);
        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.f_58857_, (Vec3i)this.f_58858_);
        if (contraption.containsBlockBreakers()) {
            this.award(AllAdvancements.CONTRAPTION_ACTORS);
        }
        this.running = true;
        this.disjointAngle = 0.0f;
        this.sendData();
        this.updateGeneratedRotation();
    }

    @NoOptimize
    public void disassemble() {
        if (!this.running && this.movedContraption == null) {
            return;
        }
        this.disjointAngle = 0.0f;
        this.sequencedAngleLimit = -1.0;
        if (this.isWindmill()) {
            this.applyRotation();
        }
        if (this.movedContraption != null) {
            this.movedContraption.disassemble();
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer(this.f_58857_, (Vec3i)this.f_58858_);
        }
        this.movedContraption = null;
        this.running = false;
        this.updateGeneratedRotation();
        this.assembleNextTick = false;
        this.sendData();
    }

    private static final void tick$lambda$0(BlockEntityBehaviour obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        obj.tick();
    }
}

