/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.create_interactive.content.mechanical_propagator;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.mojang.math.Axis;
import com.simibubi.create.content.contraptions.bearing.IBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.BackHalfShaftInstance;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.valkyrienskies.create_interactive.CreateInteractivePartialModels;
import org.valkyrienskies.create_interactive.services.NoOptimize;

public final class MechPropBearingInstance<B extends KineticBlockEntity>
extends BackHalfShaftInstance<B>
implements DynamicInstance {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OrientedData topInstance;
    @NotNull
    private final Axis rotationAxis;
    @NotNull
    private final Quaternionf blockOrientation;

    public MechPropBearingInstance(@Nullable MaterialManager materialManager, B blockEntity) {
        super(materialManager, blockEntity);
        Direction facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61372_);
        Axis axis = Axis.m_253057_((Vector3f)Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.axis).m_253071_());
        Intrinsics.checkNotNullExpressionValue((Object)axis, (String)"of(...)");
        this.rotationAxis = axis;
        Intrinsics.checkNotNull((Object)facing);
        this.blockOrientation = MechPropBearingInstance.Companion.getBlockStateOrientation(facing);
        PartialModel top = CreateInteractivePartialModels.INSTANCE.getBEARING_TOP_PROPAGATOR();
        InstanceData instanceData = this.getOrientedMaterial().getModel(top, this.blockState).createInstance();
        Intrinsics.checkNotNullExpressionValue((Object)instanceData, (String)"createInstance(...)");
        this.topInstance = (OrientedData)instanceData;
        this.topInstance.setPosition(this.getInstancePosition()).setRotation(this.blockOrientation);
    }

    @NoOptimize
    public void beginFrame() {
        BlockEntity blockEntity = this.blockEntity;
        Intrinsics.checkNotNull((Object)blockEntity);
        float interpolatedAngle = ((IBearingBlockEntity)blockEntity).getInterpolatedAngle(AnimationTickHolder.getPartialTicks() - 1.0f);
        Quaternionf quaternionf = this.rotationAxis.m_252977_(interpolatedAngle);
        Intrinsics.checkNotNullExpressionValue((Object)quaternionf, (String)"rotationDegrees(...)");
        Quaternionf rot = quaternionf;
        rot.mul((Quaternionfc)this.blockOrientation);
        this.topInstance.setRotation(rot);
    }

    @NoOptimize
    public void updateLight() {
        super.updateLight();
        FlatLit[] flatLitArray = new FlatLit[]{this.topInstance};
        this.relight(this.pos, flatLitArray);
    }

    @NoOptimize
    public void remove() {
        super.remove();
        this.topInstance.delete();
    }

    public static final class Companion {
        private Companion() {
        }

        private final Quaternionf getBlockStateOrientation(Direction facing) {
            Quaternionf quaternionf;
            if (facing.m_122434_().m_122479_()) {
                Quaternionf quaternionf2 = Axis.f_252436_.m_252977_(AngleHelper.horizontalAngle((Direction)facing.m_122424_()));
                Intrinsics.checkNotNull((Object)quaternionf2);
                quaternionf = quaternionf2;
            } else {
                quaternionf = new Quaternionf();
            }
            Quaternionf orientation = quaternionf;
            orientation.mul((Quaternionfc)Axis.f_252529_.m_252977_((float)-90 - AngleHelper.verticalAngle((Direction)facing)));
            return orientation;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

