/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.create_interactive.content.propagating_axis;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.kinetics.base.DirectionalShaftHalvesBlockEntity;
import java.lang.ref.WeakReference;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3ic;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.create_interactive.CreateInteractiveUtil;
import org.valkyrienskies.create_interactive.GameContent;
import org.valkyrienskies.create_interactive.MinecraftUtilsKt;
import org.valkyrienskies.create_interactive.content.PropagatingTools;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public abstract class PropagatingAxisBlockEntity
extends DirectionalShaftHalvesBlockEntity {
    @Nullable
    private Contraption _contraption;
    private int _id;

    public PropagatingAxisBlockEntity(@NotNull BlockEntityType<? extends PropagatingAxisBlockEntity> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        this._id = -1;
    }

    public final Direction.Axis getAxis() {
        return (Direction.Axis)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61365_);
    }

    public final Boolean isConnected() {
        return (Boolean)this.m_58900_().m_61143_((Property)GameContent.INSTANCE.getCONNECTED());
    }

    @Nullable
    public final Contraption getContraption() {
        Contraption contraption;
        if (!this.isConnected().booleanValue()) {
            contraption = null;
        } else {
            contraption = this._contraption;
            if (contraption == null) {
                Contraption contraption2;
                Contraption $this$_get_contraption__u24lambda_u240 = contraption2 = this.findBase();
                boolean bl = false;
                this._contraption = $this$_get_contraption__u24lambda_u240;
                contraption = contraption2;
            }
        }
        return contraption;
    }

    public final int getId() {
        int n;
        if (!this.isConnected().booleanValue()) {
            n = -1;
        } else {
            if (this._contraption == null) {
                this.findBase();
            }
            n = this._id;
        }
        return n;
    }

    private final Contraption findBase() {
        Direction.Axis axis = this.getAxis();
        Intrinsics.checkNotNullExpressionValue((Object)axis, (String)"<get-axis>(...)");
        for (Direction dir : MinecraftUtilsKt.getDirections(axis)) {
            BlockState state;
            int length = 0;
            BlockPos location = this.f_58858_;
            do {
                BlockPos shift = location.m_121945_(dir);
                Level level = this.f_58857_;
                Intrinsics.checkNotNull((Object)level);
                state = level.m_8055_(shift);
                location = shift;
                ++length;
                Intrinsics.checkNotNull((Object)state);
                if (PropagatingTools.INSTANCE.isPropagateBase(state)) {
                    this._id = length;
                    Level level2 = this.f_58857_;
                    Intrinsics.checkNotNull((Object)level2);
                    BlockEntity blockEntity = level2.m_7702_(shift);
                    Intrinsics.checkNotNull((Object)blockEntity);
                    AbstractContraptionEntity abstractContraptionEntity = PropagatingTools.INSTANCE.getContraptionOfPropagateBase(blockEntity);
                    return abstractContraptionEntity != null ? abstractContraptionEntity.getContraption() : null;
                }
                Level level3 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level3);
                BlockPos blockPos = location;
                Intrinsics.checkNotNull((Object)blockPos);
                if (!PropagatingTools.INSTANCE.isContraptionBase(level3, blockPos)) continue;
                Map<Long, WeakReference<AbstractContraptionEntity>> map = CreateInteractiveUtil.INSTANCE.getShipIdToContraptionEntityServer();
                BlockPos blockPos2 = location;
                Intrinsics.checkNotNull((Object)blockPos2);
                Ship ship = VSGameUtilsKt.getShipManagingPos((Level)this.f_58857_, (BlockPos)blockPos2);
                Intrinsics.checkNotNull((Object)ship);
                WeakReference<AbstractContraptionEntity> weakReference = map.get(ship.getId());
                if (weakReference == null) {
                    throw new IllegalStateException("Can't find owning contraption entity!");
                }
                WeakReference<AbstractContraptionEntity> weakEntity = weakReference;
                AbstractContraptionEntity abstractContraptionEntity = (AbstractContraptionEntity)weakEntity.get();
                if (abstractContraptionEntity == null) {
                    throw new IllegalStateException("Owner contraption entity is no more?");
                }
                AbstractContraptionEntity entity = abstractContraptionEntity;
                this._id = length;
                return entity.getContraption();
            } while (PropagatingTools.INSTANCE.isConnectedPropagator(state));
        }
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)blockPos);
        if (ship != null) {
            Level level4 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level4);
            if ((ship = CreateInteractiveUtil.INSTANCE.getChunkClaimCenterPos(ship, level4)) != null) {
                Ship it = ship;
                boolean bl = false;
                System.out.println((Object)("Found ship center at " + (Vector3ic)it));
            }
        }
        Boolean bl = this.isConnected();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"<get-isConnected>(...)");
        if (bl.booleanValue()) {
            throw new IllegalStateException("This block entity is connected to a base, but we can't find it!");
        }
        return null;
    }
}

