/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.create_interactive.forge.mixin_logic.mixin;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.logistics.vault.ItemVaultBlockEntity;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.create_interactive.VS2KotlinHelper;
import org.valkyrienskies.create_interactive.forge.WrappedIItemHandlerModifiable;
import org.valkyrienskies.create_interactive.forge.mixinducks.CombinedInvWrapperDuck;
import org.valkyrienskies.create_interactive.forge.mixinducks.CombinedTankWrapperDuck;

public final class MixinMountedStorageManagerLogic {
    @NotNull
    public static final MixinMountedStorageManagerLogic INSTANCE = new MixinMountedStorageManagerLogic();

    private MixinMountedStorageManagerLogic() {
    }

    public final void preEntityTick$create_interactive(@NotNull AbstractContraptionEntity entity, @Nullable Long shipId, @NotNull List<? extends IItemHandlerModifiable> externalStorages, @NotNull Contraption.ContraptionInvWrapper inventory, @NotNull Contraption.ContraptionInvWrapper fuelInventory, @NotNull CombinedTankWrapper fluidInventory) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(externalStorages, (String)"externalStorages");
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)fuelInventory, (String)"fuelInventory");
        Intrinsics.checkNotNullParameter((Object)fluidInventory, (String)"fluidInventory");
        if (shipId != null) {
            Level level = entity.m_9236_();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerShip serverShip = VS2KotlinHelper.getShipById((ServerLevel)level, shipId);
            List inventories = new ArrayList();
            List fuelInventories = new ArrayList();
            List fluidInventories = new ArrayList();
            ServerShip serverShip2 = serverShip;
            if (serverShip2 != null && (serverShip2 = serverShip2.getActiveChunksSet()) != null) {
                serverShip2.forEach((arg_0, arg_1) -> MixinMountedStorageManagerLogic.preEntityTick$lambda$0(entity, inventories, fuelInventories, fluidInventories, arg_0, arg_1));
            }
            inventories.addAll((Collection)externalStorages);
            fuelInventories.addAll((Collection)externalStorages);
            ((CombinedInvWrapperDuck)inventory).ci$setInventories(inventories);
            ((CombinedInvWrapperDuck)fuelInventory).ci$setInventories(fuelInventories);
            ((CombinedTankWrapperDuck)fluidInventory).ci$setInventories(fluidInventories);
        } else {
            ((CombinedInvWrapperDuck)inventory).ci$setInventories(CollectionsKt.emptyList());
            ((CombinedInvWrapperDuck)fuelInventory).ci$setInventories(CollectionsKt.emptyList());
            ((CombinedTankWrapperDuck)fluidInventory).ci$setInventories(CollectionsKt.emptyList());
        }
    }

    private static final void preEntityTick$lambda$0(AbstractContraptionEntity $entity, List $inventories, List $fuelInventories, List $fluidInventories, int chunkX, int chunkZ) {
        Intrinsics.checkNotNullParameter((Object)$entity, (String)"$entity");
        Intrinsics.checkNotNullParameter((Object)$inventories, (String)"$inventories");
        Intrinsics.checkNotNullParameter((Object)$fuelInventories, (String)"$fuelInventories");
        Intrinsics.checkNotNullParameter((Object)$fluidInventories, (String)"$fluidInventories");
        LevelChunk chunk = $entity.m_9236_().m_6325_(chunkX, chunkZ);
        for (BlockEntity be : chunk.m_62954_().values()) {
            if (be instanceof ItemVaultBlockEntity) {
                ItemStackHandler itemStackHandler = ((ItemVaultBlockEntity)be).getInventoryOfBlock();
                Intrinsics.checkNotNullExpressionValue((Object)itemStackHandler, (String)"getInventoryOfBlock(...)");
                $inventories.add(itemStackHandler);
                continue;
            }
            IItemHandler newInv = be.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().orElse(null);
            if (newInv == null) continue;
            if (newInv instanceof IItemHandlerModifiable) {
                $inventories.add(newInv);
                $fuelInventories.add(newInv);
                continue;
            }
            IItemHandlerModifiable wrappedNewInv = new WrappedIItemHandlerModifiable(newInv);
            $inventories.add(wrappedNewInv);
            $fuelInventories.add(wrappedNewInv);
        }
        for (BlockEntity be : chunk.m_62954_().values()) {
            IFluidHandler iFluidHandler = (IFluidHandler)be.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
            if (iFluidHandler == null) continue;
            IFluidHandler newFluidInv = iFluidHandler;
            $fluidInventories.add(newFluidInv);
        }
    }
}

