/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.create_interactive.mixin_logic;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllInteractionBehaviours;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.simibubi.create.content.contraptions.actors.seat.SeatBlock;
import com.simibubi.create.content.contraptions.bearing.StabilizedBearingMovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.behaviour.MovingInteractionBehaviour;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3ic;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.create_interactive.CreateInteractiveUtil;
import org.valkyrienskies.create_interactive.mixin.CarriageBogeyAccessor;
import org.valkyrienskies.create_interactive.mixin.CarriageContraptionAccessor;
import org.valkyrienskies.create_interactive.mixin.ContraptionAccessor;
import org.valkyrienskies.create_interactive.mixin.StructureBlockInfoAccessor;
import org.valkyrienskies.create_interactive.mixin_logic.MixinContraptionLogic;
import org.valkyrienskies.create_interactive.mixinducks.AbstractContraptionEntityDuck;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public final class MixinContraptionLogic {
    @NotNull
    public static final MixinContraptionLogic INSTANCE = new MixinContraptionLogic();
    @NotNull
    private static final BlockPos INVALID_SEAT_POS = new BlockPos(-100000, 0, -100000);

    private MixinContraptionLogic() {
    }

    public final void preOnEntityCreated$create_interactive(@NotNull Map<BlockPos, StructureTemplate.StructureBlockInfo> initialBlocks, @NotNull AbstractContraptionEntity entity) {
        Intrinsics.checkNotNullParameter(initialBlocks, (String)"initialBlocks");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Level level = entity.m_9236_();
        if (level.f_46443_) {
            return;
        }
        Long prevId = ((AbstractContraptionEntityDuck)entity).ci$getShadowShipId();
        if (prevId != null) {
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            if (VSGameUtilsKt.getShipObjectWorld((ServerLevel)((ServerLevel)level)).getAllShips().getById(prevId.longValue()) != null) {
                return;
            }
        }
        BlockPos blockPos = BlockPos.m_274446_((Position)((Position)entity.m_20182_()));
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel serverLevel = (ServerLevel)level;
        Contraption contraption = entity.getContraption();
        Intrinsics.checkNotNullExpressionValue((Object)contraption, (String)"getContraption(...)");
        Intrinsics.checkNotNull((Object)blockPos);
        Long l = CreateInteractiveUtil.INSTANCE.createShipForContraption(serverLevel, contraption, blockPos, initialBlocks);
        if (l == null) {
            return;
        }
        long shipId = l;
        ((AbstractContraptionEntityDuck)entity).ci$setShadowShipId(shipId);
    }

    public final void preAddBlocksToWorld$create_interactive(boolean disassembled, @Nullable AbstractContraptionEntity entity, @NotNull Map<BlockPos, StructureTemplate.StructureBlockInfo> blocks, @NotNull Level world, @NotNull Function2<? super Level, ? super BlockPos, ? extends CompoundTag> getBlockEntityNBT) {
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(getBlockEntityNBT, (String)"getBlockEntityNBT");
        if (disassembled) {
            return;
        }
        AbstractContraptionEntity entityCopy = entity;
        if (entityCopy == null) {
            System.out.println((Object)"Susmogus!");
            return;
        }
        AbstractContraptionEntityDuck duck = (AbstractContraptionEntityDuck)entityCopy;
        Long l = duck.ci$getShadowShipId();
        if (l == null) {
            return;
        }
        long shadowShipId = ((Number)l).longValue();
        Ship ship = VSGameUtilsKt.getShipObjectWorld((Level)world).getAllShips().getById(shadowShipId);
        if (ship == null) {
            return;
        }
        Ship ship2 = ship;
        Vector3ic shipCenter = CreateInteractiveUtil.INSTANCE.getChunkClaimCenterPos(ship2, world);
        ship2.getActiveChunksSet().forEach((arg_0, arg_1) -> MixinContraptionLogic.preAddBlocksToWorld$lambda$0(world, shipCenter, getBlockEntityNBT, blocks, arg_0, arg_1));
    }

    public final void postAddBlocksToWorld$create_interactive(@NotNull AbstractContraptionEntity entity, @NotNull Map<BlockPos, StructureTemplate.StructureBlockInfo> blocks, @NotNull Level world, @NotNull StructureTransform transform) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        if (!(world instanceof ServerLevel)) {
            return;
        }
        Long l = ((AbstractContraptionEntityDuck)entity).ci$getShadowShipId();
        if (l == null) {
            return;
        }
        long shipId = ((Number)l).longValue();
        ServerShip serverShip = (ServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)((ServerLevel)world)).getAllShips().getById(shipId);
        if (serverShip == null) {
            return;
        }
        ServerShip shipFor = serverShip;
        Vector3ic shipCenter = CreateInteractiveUtil.INSTANCE.getChunkClaimCenterPos((Ship)shipFor, world);
        ServerLevel serverLevel = (ServerLevel)world;
        BlockPos blockPos = VectorConversionsMCKt.toBlockPos((Vector3ic)shipCenter);
        BlockPos blockPos2 = entity.getContraption().anchor;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"anchor");
        CreateInteractiveUtil.INSTANCE.attemptTrainRelocation$create_interactive(serverLevel, blockPos, blocks, (Vector3ic)VectorConversionsMCKt.toJOML((Vec3i)((Vec3i)blockPos2)), transform);
    }

    private final <K, V> List<K> removeValues(Map<K, V> $this$removeValues, V value) {
        List removed = new ArrayList(0);
        Iterator<Map.Entry<K, V>> it = $this$removeValues.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, V> next = it.next();
            if (!Intrinsics.areEqual(next.getValue(), value)) continue;
            removed.add(next.getKey());
            it.remove();
        }
        return removed;
    }

    public final void setBlock$create_interactive(@NotNull Map<BlockPos, StructureTemplate.StructureBlockInfo> blocks, @NotNull List<MutablePair<StructureTemplate.StructureBlockInfo, MovementContext>> actors, @NotNull AABB bounds, @NotNull BlockPos localPos, @NotNull StructureTemplate.StructureBlockInfo structureBlockInfo, @NotNull Function1<? super AABB, Unit> setBounds, @NotNull Function1<? super MovementContext, Unit> disableActorOnStart, @NotNull Set<BlockPos> changedActors, @NotNull Map<BlockPos, MovingInteractionBehaviour> interactors, @NotNull Contraption contraption) {
        MovementBehaviour newBehavior;
        BlockState prevBlockState;
        block28: {
            int $i$f$forEach;
            Direction[] removedEntities;
            boolean newIsSeat;
            boolean prevWasSeat;
            block27: {
                Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
                Intrinsics.checkNotNullParameter(actors, (String)"actors");
                Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
                Intrinsics.checkNotNullParameter((Object)localPos, (String)"localPos");
                Intrinsics.checkNotNullParameter((Object)structureBlockInfo, (String)"structureBlockInfo");
                Intrinsics.checkNotNullParameter(setBounds, (String)"setBounds");
                Intrinsics.checkNotNullParameter(disableActorOnStart, (String)"disableActorOnStart");
                Intrinsics.checkNotNullParameter(changedActors, (String)"changedActors");
                Intrinsics.checkNotNullParameter(interactors, (String)"interactors");
                Intrinsics.checkNotNullParameter((Object)contraption, (String)"contraption");
                StructureTemplate.StructureBlockInfo structureBlockInfo2 = blocks.get(localPos);
                Object object = prevBlockState = structureBlockInfo2 != null ? structureBlockInfo2.f_74676_() : null;
                if (!Intrinsics.areEqual((Object)structureBlockInfo.f_74676_().m_60734_(), (Object)Blocks.f_50016_)) {
                    blocks.put(localPos, structureBlockInfo);
                    AABB aABB = bounds.m_82367_(new AABB(localPos));
                    Intrinsics.checkNotNullExpressionValue((Object)aABB, (String)"minmax(...)");
                    setBounds.invoke((Object)aABB);
                } else {
                    blocks.remove(localPos);
                }
                BlockState blockState = prevBlockState;
                prevWasSeat = (blockState != null ? blockState.m_60734_() : null) instanceof SeatBlock;
                newIsSeat = structureBlockInfo.f_74676_().m_60734_() instanceof SeatBlock;
                if (!prevWasSeat || newIsSeat) break block27;
                int indexOf = contraption.getSeats().indexOf(localPos);
                if (indexOf == -1) break block28;
                contraption.getSeats().set(indexOf, INVALID_SEAT_POS);
                Map map = contraption.getSeatMapping();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getSeatMapping(...)");
                removedEntities = this.removeValues(map, indexOf);
                Iterable $this$forEach$iv = (Iterable)removedEntities;
                $i$f$forEach = 0;
                Direction[] directionArray = $this$forEach$iv.iterator();
                while (directionArray.hasNext()) {
                    Object v6;
                    block26: {
                        Object element$iv = directionArray.next();
                        UUID uuid = (UUID)element$iv;
                        boolean bl = false;
                        List list = contraption.entity.m_20197_();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPassengers(...)");
                        Iterable iterable = list;
                        for (Object t : iterable) {
                            Entity it = (Entity)t;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.m_20148_(), (Object)uuid)) continue;
                            v6 = t;
                            break block26;
                        }
                        v6 = null;
                    }
                    Entity entity = v6;
                    if (entity == null) continue;
                    entity.m_6038_();
                }
                if (!(contraption instanceof CarriageContraption)) break block28;
                ((CarriageContraption)contraption).conductorSeats.remove(localPos);
                break block28;
            }
            if (!prevWasSeat && newIsSeat) {
                int invalidIndexOf = contraption.getSeats().indexOf(INVALID_SEAT_POS);
                if (invalidIndexOf != -1) {
                    contraption.getSeats().set(invalidIndexOf, localPos);
                } else {
                    contraption.getSeats().add(localPos);
                }
                if (contraption instanceof CarriageContraption) {
                    Direction[] directionArray = Iterate.directionsInAxis((Direction.Axis)((CarriageContraption)contraption).getAssemblyDirection().m_122434_());
                    Intrinsics.checkNotNullExpressionValue((Object)directionArray, (String)"directionsInAxis(...)");
                    removedEntities = directionArray;
                    $i$f$forEach = removedEntities.length;
                    for (int $this$forEach$iv = 0; $this$forEach$iv < $i$f$forEach; ++$this$forEach$iv) {
                        Direction direction = removedEntities[$this$forEach$iv];
                        if (!((CarriageContraption)contraption).inControl(localPos, direction)) continue;
                        ((CarriageContraption)contraption).conductorSeats.computeIfAbsent(localPos, arg_0 -> MixinContraptionLogic.setBlock$lambda$3(setBlock.2.INSTANCE, arg_0)).set(direction != ((CarriageContraption)contraption).getAssemblyDirection(), (Object)true);
                    }
                }
            }
        }
        if (contraption instanceof CarriageContraption) {
            BlockState blockState = prevBlockState;
            boolean prevWasTrainControls = blockState != null ? AllBlocks.TRAIN_CONTROLS.has(blockState) : false;
            boolean newIsTrainControls = AllBlocks.TRAIN_CONTROLS.has(structureBlockInfo.f_74676_());
            if (prevWasTrainControls || newIsTrainControls) {
                Direction[] directionArray = Iterate.directionsInAxis((Direction.Axis)((CarriageContraption)contraption).getAssemblyDirection().m_122434_());
                Intrinsics.checkNotNullExpressionValue((Object)directionArray, (String)"directionsInAxis(...)");
                for (Direction direction : directionArray) {
                    Direction[] bl;
                    BlockPos seatPos = localPos.m_121945_(direction.m_122424_());
                    ((CarriageContraption)contraption).conductorSeats.remove(seatPos);
                    Intrinsics.checkNotNullExpressionValue((Object)Iterate.directionsInAxis((Direction.Axis)((CarriageContraption)contraption).getAssemblyDirection().m_122434_()), (String)"directionsInAxis(...)");
                    for (Direction direction2 : bl) {
                        if (!((CarriageContraption)contraption).inControl(seatPos, direction2)) continue;
                        ((CarriageContraption)contraption).conductorSeats.computeIfAbsent(seatPos, arg_0 -> MixinContraptionLogic.setBlock$lambda$4(setBlock.3.INSTANCE, arg_0)).set(direction2 != ((CarriageContraption)contraption).getAssemblyDirection(), (Object)true);
                    }
                }
            }
            BlockState blockState2 = prevBlockState;
            boolean prevWasBurner = (blockState2 != null ? blockState2.m_60734_() : null) instanceof BlazeBurnerBlock;
            boolean newIsBurner = structureBlockInfo.f_74676_().m_60734_() instanceof BlazeBurnerBlock;
            if (prevWasBurner && !newIsBurner) {
                ((CarriageContraptionAccessor)contraption).getAssembledBlazeBurners().remove(localPos);
                ((CarriageContraption)contraption).blazeBurnerConductors = Couple.create((Object)false, (Object)false);
                for (BlockPos burners : ((CarriageContraptionAccessor)contraption).getAssembledBlazeBurners()) {
                    Direction[] directionArray;
                    Intrinsics.checkNotNullExpressionValue((Object)Iterate.directionsInAxis((Direction.Axis)((CarriageContraption)contraption).getAssemblyDirection().m_122434_()), (String)"directionsInAxis(...)");
                    for (Direction direction : directionArray) {
                        if (!((CarriageContraption)contraption).inControl(burners, direction)) continue;
                        ((CarriageContraption)contraption).blazeBurnerConductors.set(direction != ((CarriageContraption)contraption).getAssemblyDirection(), (Object)true);
                    }
                }
            } else if (!prevWasBurner && newIsBurner) {
                ((CarriageContraptionAccessor)contraption).getAssembledBlazeBurners().add(localPos);
                Direction[] directionArray = Iterate.directionsInAxis((Direction.Axis)((CarriageContraption)contraption).getAssemblyDirection().m_122434_());
                Intrinsics.checkNotNullExpressionValue((Object)directionArray, (String)"directionsInAxis(...)");
                for (Direction direction : directionArray) {
                    if (!((CarriageContraption)contraption).inControl(localPos, direction)) continue;
                    ((CarriageContraption)contraption).blazeBurnerConductors.set(direction != ((CarriageContraption)contraption).getAssemblyDirection(), (Object)true);
                }
            }
        }
        if ((newBehavior = AllMovementBehaviours.getBehaviour((BlockState)structureBlockInfo.f_74676_())) != null && !(newBehavior instanceof StabilizedBearingMovementBehaviour)) {
            MovementBehaviour behaviour;
            MovementContext context = new MovementContext(contraption.entity.m_9236_(), structureBlockInfo, contraption);
            MovementBehaviour movementBehaviour = behaviour = AllMovementBehaviours.getBehaviour((BlockState)structureBlockInfo.f_74676_());
            if (movementBehaviour != null) {
                movementBehaviour.startMoving(context);
            }
            if (behaviour instanceof ContraptionControlsMovement) {
                disableActorOnStart.invoke((Object)context);
            }
            actors.removeIf(arg_0 -> MixinContraptionLogic.setBlock$lambda$5((Function1)new Function1<MutablePair<StructureTemplate.StructureBlockInfo, MovementContext>, Boolean>(structureBlockInfo){
                final /* synthetic */ StructureTemplate.StructureBlockInfo $structureBlockInfo;
                {
                    this.$structureBlockInfo = $structureBlockInfo;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> next) {
                    Intrinsics.checkNotNullParameter(next, (String)"next");
                    return Intrinsics.areEqual((Object)((StructureTemplate.StructureBlockInfo)next.left).f_74675_(), (Object)this.$structureBlockInfo.f_74675_());
                }
            }, arg_0));
            MutablePair mutablePair = MutablePair.of((Object)structureBlockInfo, (Object)context);
            Intrinsics.checkNotNullExpressionValue((Object)mutablePair, (String)"of(...)");
            actors.add((MutablePair<StructureTemplate.StructureBlockInfo, MovementContext>)mutablePair);
            BlockPos blockPos = structureBlockInfo.f_74675_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"pos(...)");
            changedActors.add(blockPos);
        } else {
            boolean anyRemoved2 = actors.removeIf(arg_0 -> MixinContraptionLogic.setBlock$lambda$6((Function1)new Function1<MutablePair<StructureTemplate.StructureBlockInfo, MovementContext>, Boolean>(structureBlockInfo){
                final /* synthetic */ StructureTemplate.StructureBlockInfo $structureBlockInfo;
                {
                    this.$structureBlockInfo = $structureBlockInfo;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> next) {
                    Intrinsics.checkNotNullParameter(next, (String)"next");
                    return Intrinsics.areEqual((Object)((StructureTemplate.StructureBlockInfo)next.left).f_74675_(), (Object)this.$structureBlockInfo.f_74675_());
                }
            }, arg_0));
            if (anyRemoved2) {
                BlockPos blockPos = structureBlockInfo.f_74675_();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"pos(...)");
                changedActors.add(blockPos);
            }
        }
        MovingInteractionBehaviour interactionBehaviour = AllInteractionBehaviours.getBehaviour((BlockState)structureBlockInfo.f_74676_());
        if (interactionBehaviour != null) {
            interactors.put(localPos, interactionBehaviour);
        } else {
            interactors.remove(structureBlockInfo.f_74675_());
        }
    }

    public final boolean hasActorAtPos$create_interactive(@NotNull BlockPos localPos, @NotNull List<? extends MutablePair<StructureTemplate.StructureBlockInfo, MovementContext>> actors) {
        Intrinsics.checkNotNullParameter((Object)localPos, (String)"localPos");
        Intrinsics.checkNotNullParameter(actors, (String)"actors");
        return this.getActorAtPos$create_interactive(localPos, actors) != null;
    }

    public final boolean hasBogeyAtPos$create_interactive(@NotNull AbstractContraptionEntity entity, @NotNull BlockPos localPos) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)localPos, (String)"localPos");
        if (!(entity instanceof CarriageContraptionEntity)) {
            return false;
        }
        Carriage carriage = ((CarriageContraptionEntity)entity).getCarriage();
        Intrinsics.checkNotNullExpressionValue((Object)carriage, (String)"getCarriage(...)");
        Carriage carriage2 = carriage;
        int bogeySpacing = carriage2.bogeySpacing;
        for (CarriageBogey bogey : carriage2.bogeys) {
            BlockPos bogeyPos;
            if (bogey == null || !Intrinsics.areEqual((Object)(bogeyPos = ((CarriageBogeyAccessor)bogey).getIsLeading() ? BlockPos.f_121853_ : BlockPos.f_121853_.m_5484_(((CarriageContraptionEntity)entity).getInitialOrientation().m_122428_(), bogeySpacing)), (Object)localPos)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public final Pair<StructureTemplate.StructureBlockInfo, MovementContext> getActorAtPos$create_interactive(@NotNull BlockPos localPos, @NotNull List<? extends MutablePair<StructureTemplate.StructureBlockInfo, MovementContext>> actors) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)localPos, (String)"localPos");
            Intrinsics.checkNotNullParameter(actors, (String)"actors");
            Iterable $this$firstOrNull$iv = actors;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MutablePair it = (MutablePair)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((StructureTemplate.StructureBlockInfo)it.left).f_74675_(), (Object)localPos)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final void preWriteBlocksCompound$create_interactive(@NotNull Contraption contraption) {
        Intrinsics.checkNotNullParameter((Object)contraption, (String)"contraption");
        AbstractContraptionEntity abstractContraptionEntity = contraption.entity;
        if (abstractContraptionEntity == null) {
            return;
        }
        AbstractContraptionEntity contraptionEntity = abstractContraptionEntity;
        Level level = contraption.entity.m_9236_();
        Long l = ((AbstractContraptionEntityDuck)contraptionEntity).ci$getShadowShipId();
        if (l == null) {
            return;
        }
        long shipId = ((Number)l).longValue();
        Ship ship = VSGameUtilsKt.getShipObjectWorld((Level)level).getAllShips().getById(shipId);
        if (ship == null) {
            return;
        }
        Ship ship2 = ship;
        Intrinsics.checkNotNull((Object)level);
        Vector3ic centerPos = CreateInteractiveUtil.INSTANCE.getChunkClaimCenterPos(ship2, level);
        for (StructureTemplate.StructureBlockInfo block : contraption.getBlocks().values()) {
            BlockPos pos = block.f_74675_().m_7918_(centerPos.x(), centerPos.y(), centerPos.z());
            Intrinsics.checkNotNull((Object)block, (String)"null cannot be cast to non-null type org.valkyrienskies.create_interactive.mixin.StructureBlockInfoAccessor");
            ((StructureBlockInfoAccessor)block).setNbt(((ContraptionAccessor)contraption).invokeGetBlockEntityNBT(level, pos));
        }
    }

    private static final void preAddBlocksToWorld$lambda$0(Level $world, Vector3ic $shipCenter, Function2 $getBlockEntityNBT, Map $blocks, int chunkX, int chunkZ) {
        Intrinsics.checkNotNullParameter((Object)$world, (String)"$world");
        Intrinsics.checkNotNullParameter((Object)$shipCenter, (String)"$shipCenter");
        Intrinsics.checkNotNullParameter((Object)$getBlockEntityNBT, (String)"$getBlockEntityNBT");
        Intrinsics.checkNotNullParameter((Object)$blocks, (String)"$blocks");
        LevelChunk levelChunk = $world.m_6325_(chunkX, chunkZ);
        Intrinsics.checkNotNullExpressionValue((Object)levelChunk, (String)"getChunk(...)");
        ChunkAccess chunkAccess = (ChunkAccess)levelChunk;
        for (BlockPos blockPos : chunkAccess.m_5928_()) {
            BlockPos localPos = blockPos.m_7918_(-$shipCenter.x(), -$shipCenter.y(), -$shipCenter.z());
            BlockState blockState = $world.m_8055_(blockPos);
            Intrinsics.checkNotNull((Object)blockPos);
            CompoundTag compoundTag = (CompoundTag)$getBlockEntityNBT.invoke((Object)$world, (Object)blockPos);
            StructureTemplate.StructureBlockInfo blockInfo = new StructureTemplate.StructureBlockInfo(localPos, blockState, compoundTag);
            Intrinsics.checkNotNull((Object)localPos);
            $blocks.put(localPos, blockInfo);
        }
    }

    private static final Couple setBlock$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Couple)$tmp0.invoke(p0);
    }

    private static final Couple setBlock$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Couple)$tmp0.invoke(p0);
    }

    private static final boolean setBlock$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean setBlock$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

