/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.create_interactive.mixin_logic;

import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public final class MixinITrackBlockLogic {
    @NotNull
    public static final MixinITrackBlockLogic INSTANCE = new MixinITrackBlockLogic();

    private MixinITrackBlockLogic() {
    }

    @NotNull
    public final Pair<Vec3, Direction.AxisDirection> overwriteGetNearestTrackAxis$create_interactive(@NotNull ITrackBlock trackBlock, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Vec3 lookVec) {
        Intrinsics.checkNotNullParameter((Object)trackBlock, (String)"trackBlock");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)lookVec, (String)"lookVec");
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)(world instanceof Level ? (Level)world : null), (BlockPos)pos);
        if (ship == null) {
            return this.originalGetNearestTrackAxis(trackBlock, world, pos, state, lookVec);
        }
        Ship ship2 = ship;
        ShipTransform transform = ship2 instanceof ClientShip ? ((ClientShip)ship2).getRenderTransform() : ship2.getTransform();
        Vector3d vector3d = transform.getShipToWorldRotation().transformInverse(VectorConversionsMCKt.toJOML((Vec3)lookVec));
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"transformInverse(...)");
        Vec3 lookVecInLocal = VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)vector3d));
        return this.originalGetNearestTrackAxis(trackBlock, world, pos, state, lookVecInLocal);
    }

    private final Pair<Vec3, Direction.AxisDirection> originalGetNearestTrackAxis(ITrackBlock $this$originalGetNearestTrackAxis, BlockGetter world, BlockPos pos, BlockState state, Vec3 lookVec) {
        Vec3 best = null;
        double bestDiff = Double.MAX_VALUE;
        for (Vec3 vec3 : $this$originalGetNearestTrackAxis.getTrackAxes(world, pos, state)) {
            Intrinsics.checkNotNullExpressionValue((Object)Iterate.positiveAndNegative, (String)"positiveAndNegative");
            for (int opposite : Iterate.positiveAndNegative) {
                double distanceTo = vec3.m_82541_().m_82554_(lookVec.m_82490_((double)opposite));
                if (distanceTo > bestDiff) continue;
                bestDiff = distanceTo;
                best = vec3;
            }
        }
        Vec3 vec3 = best;
        Intrinsics.checkNotNull(vec3);
        Pair pair = Pair.of(best, (Object)(lookVec.m_82526_(vec3.m_82542_(1.0, 0.0, 1.0).m_82541_()) < 0.0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE));
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"of(...)");
        return pair;
    }
}

