/*
 * Decompiled with CFR 0.152.
 */
package net.cristellib.builtinpacks;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.cristellib.CristelLib;
import net.cristellib.CristelLibExpectPlatform;
import net.cristellib.builtinpacks.BuiltinResourcePackSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.util.Tuple;

public class BuiltInDataPacks {
    private static final List<Tuple<Tuple<Component, PackResources>, Supplier<Boolean>>> list = new ArrayList<Tuple<Tuple<Component, PackResources>, Supplier<Boolean>>>();

    public static void registerAlwaysOnPack(ResourceLocation path, String modid, Component displayName) {
        BuiltInDataPacks.registerPack(path, modid, displayName, () -> true);
    }

    public static void registerPack(ResourceLocation path, String modid, Component displayName, Supplier<Boolean> supplier) {
        BuiltInDataPacks.registerPack(CristelLibExpectPlatform.registerBuiltinResourcePack(path, displayName, modid), displayName, supplier);
    }

    public static void registerPack(PackResources packResource, Component displayName, Supplier<Boolean> supplier) {
        list.add((Tuple<Tuple<Component, PackResources>, Supplier<Boolean>>)new Tuple((Object)new Tuple((Object)displayName, (Object)packResource), supplier));
    }

    public static void getPacks(Consumer<Pack> consumer) {
        if (list.isEmpty()) {
            return;
        }
        for (Tuple<Tuple<Component, PackResources>, Supplier<Boolean>> entry : list) {
            if (!((Boolean)((Supplier)entry.m_14419_()).get()).booleanValue()) continue;
            PackResources packResources = (PackResources)((Tuple)entry.m_14418_()).m_14419_();
            Component displayName = (Component)((Tuple)entry.m_14418_()).m_14418_();
            if (packResources == null) {
                CristelLib.LOGGER.error("Pack for " + displayName.getString() + " is null");
                continue;
            }
            if (packResources.m_5698_(PackType.SERVER_DATA).isEmpty()) continue;
            Pack pack = Pack.m_245429_((String)packResources.m_5542_(), (Component)displayName, (boolean)true, ignored -> packResources, (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)new BuiltinResourcePackSource());
            if (pack != null) {
                consumer.accept(pack);
                continue;
            }
            CristelLib.LOGGER.error(displayName.getString() + " couldn't be created");
        }
    }
}

