/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.registration.forge;

import com.google.auto.service.AutoService;
import com.google.common.base.Suppliers;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import lilypuree.decorative_blocks.registration.RegistrationProvider;
import lilypuree.decorative_blocks.registration.RegistryObject;
import lilypuree.decorative_blocks.registration.forge.ForgeBusGetter;
import lilypuree.decorative_blocks.registration.registries.RegistryBuilder;
import lilypuree.decorative_blocks.registration.registries.RegistryFeatureType;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.NewRegistryEvent;
import org.jetbrains.annotations.ApiStatus;

@AutoService(value={RegistrationProvider.Factory.class})
public class ForgeRegistrationFactory
implements RegistrationProvider.Factory {
    @Override
    public <T> RegistrationProvider<T> create(ResourceKey<? extends Registry<T>> resourceKey, String modId) {
        DeferredRegister register = DeferredRegister.create(resourceKey, (String)modId);
        Provider provider = new Provider(modId, register);
        IEventBus bus = ForgeRegistrationFactory.getBus(modId);
        register.register(bus);
        bus.addListener(provider::onNewRegistry);
        return provider;
    }

    @Nonnull
    @ApiStatus.Internal
    static IEventBus getBus(String modId) {
        Optional containerOpt;
        if (modId.equals("minecraft")) {
            modId = "forge";
        }
        if ((containerOpt = ModList.get().getModContainerById(modId)).isEmpty()) {
            throw new NullPointerException("Cannot find mod container for id " + modId);
        }
        IEventBus modBus = ForgeBusGetter.getBus((ModContainer)containerOpt.get());
        if (modBus == null) {
            throw new NullPointerException("Cannot get the mod event bus for the mod container with the mod id of " + modId);
        }
        return modBus;
    }

    private static class Provider<T>
    implements RegistrationProvider<T> {
        private final String modId;
        private final DeferredRegister<T> registry;
        private net.minecraftforge.registries.RegistryBuilder<T> regBuilder;
        private final Set<RegistryObject<T>> entries = new HashSet<RegistryObject<T>>();
        private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries);
        private final Supplier<Registry<T>> registryInstance = Suppliers.memoize(() -> (Registry)Provider.get(BuiltInRegistries.f_257047_, this.getRegistryKey()));

        private Provider(String modId, DeferredRegister<T> registry) {
            this.modId = modId;
            this.registry = registry;
        }

        private void onNewRegistry(NewRegistryEvent event) {
            if (this.regBuilder != null) {
                event.create(this.regBuilder);
            }
        }

        @Override
        public String getModId() {
            return this.modId;
        }

        @Override
        public ResourceKey<? extends Registry<T>> getRegistryKey() {
            return this.registry.getRegistryKey();
        }

        @Override
        public Registry<T> getRegistry() {
            return this.registryInstance.get();
        }

        private static <T> T get(Registry<T> registry, ResourceKey<?> key) {
            return (T)registry.m_6246_(key);
        }

        @Override
        public <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> supplier) {
            final net.minecraftforge.registries.RegistryObject obj = this.registry.register(name, supplier);
            RegistryObject ro = new RegistryObject<I>(){

                @Override
                public ResourceKey<I> getResourceKey() {
                    return obj.getKey();
                }

                @Override
                public ResourceLocation getId() {
                    return obj.getId();
                }

                @Override
                public I get() {
                    return obj.get();
                }

                @Override
                public Holder<I> asHolder() {
                    return (Holder)obj.getHolder().orElseThrow();
                }
            };
            this.entries.add(ro);
            return ro;
        }

        @Override
        public Set<RegistryObject<T>> getEntries() {
            return this.entriesView;
        }

        @Override
        public RegistryBuilder<T> registryBuilder() {
            return new Builder();
        }

        private final class Builder
        implements RegistryBuilder<T> {
            private final net.minecraftforge.registries.RegistryBuilder<T> builder = new net.minecraftforge.registries.RegistryBuilder();
            private final Map<RegistryFeatureType<?>, Object> features = new HashMap();

            public Builder() {
                this.builder.hasTags();
            }

            @Override
            public <X> RegistryBuilder<T> withFeature(RegistryFeatureType<X> type, X value) {
                this.features.put(type, value);
                return this;
            }

            @Override
            public RegistryBuilder<T> withFeature(RegistryFeatureType<Void> type) {
                return this.withFeature(type, null);
            }

            @Override
            public RegistryBuilder<T> withDefaultValue(String id, Supplier<T> defaultValueSupplier) {
                Provider.this.register(id, defaultValueSupplier);
                return this.withFeature(RegistryFeatureType.DEFAULTED, new ResourceLocation(Provider.this.modId, id));
            }

            @Override
            public Supplier<Registry<T>> build() {
                this.configureBuilder();
                Provider.this.regBuilder = this.builder.setName(Provider.this.getRegistryKey().m_135782_());
                return Provider.this.registryInstance;
            }

            private void configureBuilder() {
                if (!this.features.containsKey(RegistryFeatureType.SYNCED)) {
                    this.builder.disableSync();
                }
                if (!this.features.containsKey(RegistryFeatureType.SAVED_TO_DISK)) {
                    this.builder.disableSaving();
                }
                if (!this.features.containsKey(RegistryFeatureType.SUPPORTS_OVERRIDES)) {
                    this.builder.disableOverrides();
                }
                if (this.features.containsKey(RegistryFeatureType.DEFAULTED)) {
                    this.builder.setDefaultKey((ResourceLocation)this.features.get(RegistryFeatureType.DEFAULTED));
                }
            }
        }
    }
}

