/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.decorative_core.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class AbstractStorageBlockEntity
extends BlockEntity {
    protected int itemCount = 0;
    protected String storedItemId = "";

    public AbstractStorageBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public void setItemCount(int count) {
        this.itemCount = Math.max(0, Math.min(256, count));
        this.m_6596_();
    }

    public void setStoredItem(ResourceLocation itemId) {
        this.storedItemId = itemId.toString();
        this.m_6596_();
    }

    public ResourceLocation getStoredItem() {
        return new ResourceLocation(this.storedItemId);
    }

    public void dropAllStoredItems() {
        Item storedItem;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && (storedItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.storedItemId))) != null && this.itemCount > 0) {
            while (this.itemCount > 0) {
                int dropAmount = Math.min(64, this.itemCount);
                ItemStack stack = new ItemStack((ItemLike)storedItem, dropAmount);
                this.itemCount -= dropAmount;
                Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)stack);
            }
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemCount = tag.m_128451_("ItemCount");
        if (tag.m_128441_("StoredItem")) {
            this.storedItemId = tag.m_128461_("StoredItem");
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("ItemCount", this.itemCount);
        tag.m_128359_("StoredItem", this.storedItemId);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("ItemCount", this.itemCount);
        tag.m_128359_("StoredItem", this.storedItemId);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.itemCount = tag.m_128451_("ItemCount");
        if (tag.m_128441_("StoredItem")) {
            this.storedItemId = tag.m_128461_("StoredItem");
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

