/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util;

import java.io.InvalidObjectException;

public class EnumUtil {
    public static <T extends Enum<T>> T parseEnumIgnoreCase(String enumName, Class<T> enumType) throws InvalidObjectException {
        for (Enum enumValue : (Enum[])enumType.getEnumConstants()) {
            if (!enumValue.name().equalsIgnoreCase(enumName)) continue;
            return (T)enumValue;
        }
        throw new InvalidObjectException("No Enum of type [" + enumType.getSimpleName() + "] exists with the name [" + enumName + "]. Possible enum values are: [" + EnumUtil.createEnumCsv(enumType) + "]");
    }

    public static String createEnumCsv(Class<? extends Enum<?>> enumType) {
        StringBuilder str = new StringBuilder();
        Enum<?>[] enumValues = enumType.getEnumConstants();
        for (int i = 0; i < enumValues.length; ++i) {
            if (i == 0) {
                str.append(enumValues[i].name());
                continue;
            }
            str.append(", ").append(enumValues[i].name());
        }
        return str.toString();
    }

    public static EnumComparisonResult compareEnumClassesByValues(Class<? extends Enum<?>> alphaEnum, Class<? extends Enum<?>> betaEnum) {
        Enum<?>[] betaValues;
        Enum<?>[] alphaValues = alphaEnum.getEnumConstants();
        if (alphaValues.length != (betaValues = betaEnum.getEnumConstants()).length) {
            return new EnumComparisonResult(false, EnumUtil.createFailMessageHeader(alphaEnum, betaEnum) + "the enums have [" + alphaValues.length + "] and [" + betaValues.length + "] values respectively.");
        }
        for (Enum<?> alphaVal : alphaValues) {
            boolean valueFoundInBothEnums = false;
            for (Enum<?> betaVal : betaValues) {
                if (!alphaVal.name().equals(betaVal.name())) continue;
                valueFoundInBothEnums = true;
                break;
            }
            if (valueFoundInBothEnums) continue;
            return new EnumComparisonResult(false, EnumUtil.createFailMessageHeader(alphaEnum, betaEnum) + "the enum value [" + alphaVal.name() + "] wasn't found in [" + betaEnum.getSimpleName() + "].");
        }
        return new EnumComparisonResult(true, "");
    }

    public static String createFailMessageHeader(Class<? extends Enum<?>> alphaEnum, Class<? extends Enum<?>> betaEnum) {
        return "The enums [" + alphaEnum.getSimpleName() + "] and [" + betaEnum.getSimpleName() + "] aren't equal: ";
    }

    public static class EnumComparisonResult {
        public final boolean success;
        public final String failMessage;

        public EnumComparisonResult(boolean newSuccess, String newFailMessage) {
            this.success = newSuccess;
            this.failMessage = newFailMessage;
        }
    }
}

