/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.objects.dataStreams;

import DistantHorizons.libraries.jpountz.lz4.LZ4FrameInputStream;
import com.seibel.distanthorizons.api.enums.config.EDhApiDataCompressionMode;
import com.seibel.distanthorizons.core.util.objects.dataStreams.LzmaArrayCache;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.tukaani.xz.ResettableArrayCache;
import org.tukaani.xz.XZInputStream;

public class DhDataInputStream
extends DataInputStream {
    private static final ThreadLocal<ResettableArrayCache> LZMA_RESETTABLE_ARRAY_CACHE_GETTER = ThreadLocal.withInitial(() -> new ResettableArrayCache(new LzmaArrayCache()));
    private static final Logger LOGGER = LogManager.getLogger();

    public DhDataInputStream(InputStream stream, EDhApiDataCompressionMode compressionMode) throws IOException {
        super(DhDataInputStream.warpStream(new BufferedInputStream(stream), compressionMode));
    }

    private static InputStream warpStream(InputStream stream, EDhApiDataCompressionMode compressionMode) throws IOException {
        try {
            switch (compressionMode) {
                case UNCOMPRESSED: {
                    return stream;
                }
                case LZ4: {
                    return new LZ4FrameInputStream(stream);
                }
                case LZMA2: {
                    ResettableArrayCache arrayCache = LZMA_RESETTABLE_ARRAY_CACHE_GETTER.get();
                    arrayCache.reset();
                    return new XZInputStream(stream, arrayCache);
                }
            }
            throw new IllegalArgumentException("No compressor defined for [" + (Object)((Object)compressionMode) + "]");
        }
        catch (Error e) {
            LOGGER.error("Unexpected error when wrapping DhDataInputStream, error: [" + e.getMessage() + "].", (Throwable)e);
            throw e;
        }
    }

    @Override
    public int read() throws IOException {
        try {
            return super.read();
        }
        catch (EOFException ignore) {
            return -1;
        }
        catch (IOException e) {
            if (e.getMessage().equals("Stream ended prematurely")) {
                return -1;
            }
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
    }
}

