/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import java.util.ArrayList;
import java.util.List;
import org.tukaani.xz.ArrayCache;

public class ResettableArrayCache
extends ArrayCache {
    private final ArrayCache arrayCache;
    private final List<byte[]> byteArrays;
    private final List<int[]> intArrays;

    public ResettableArrayCache(ArrayCache arrayCache) {
        this.arrayCache = arrayCache;
        if (arrayCache == ArrayCache.getDummyCache()) {
            this.byteArrays = null;
            this.intArrays = null;
        } else {
            this.byteArrays = new ArrayList<byte[]>();
            this.intArrays = new ArrayList<int[]>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getByteArray(int i, boolean bl) {
        byte[] byArray = this.arrayCache.getByteArray(i, bl);
        if (this.byteArrays != null) {
            List<byte[]> list = this.byteArrays;
            synchronized (list) {
                this.byteArrays.add(byArray);
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putArray(byte[] bs) {
        if (this.byteArrays != null) {
            List<byte[]> list = this.byteArrays;
            synchronized (list) {
                int n = this.byteArrays.lastIndexOf(bs);
                if (n != -1) {
                    this.byteArrays.remove(n);
                }
            }
            this.arrayCache.putArray(bs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getIntArray(int i, boolean bl) {
        int[] nArray = this.arrayCache.getIntArray(i, bl);
        if (this.intArrays != null) {
            List<int[]> list = this.intArrays;
            synchronized (list) {
                this.intArrays.add(nArray);
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putArray(int[] is) {
        if (this.intArrays != null) {
            List<int[]> list = this.intArrays;
            synchronized (list) {
                int n = this.intArrays.lastIndexOf(is);
                if (n != -1) {
                    this.intArrays.remove(n);
                }
            }
            this.arrayCache.putArray(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (this.byteArrays != null) {
            int n;
            List<byte[]> list = this.byteArrays;
            synchronized (list) {
                for (n = this.byteArrays.size() - 1; n >= 0; --n) {
                    this.arrayCache.putArray(this.byteArrays.get(n));
                }
                this.byteArrays.clear();
            }
            list = this.intArrays;
            synchronized (list) {
                for (n = this.intArrays.size() - 1; n >= 0; --n) {
                    this.arrayCache.putArray(this.intArrays.get(n));
                }
                this.intArrays.clear();
            }
        }
    }
}

