/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.capability.recording;

import com.cstav.evenmoreinstruments.capability.recording.RecordingCapability;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecordingCapabilityProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static final Capability<RecordingCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<RecordingCapability>(){});
    private RecordingCapability cap;
    private final LazyOptional<RecordingCapability> optional = LazyOptional.of(this::getInstance);

    private RecordingCapability getInstance() {
        return this.cap == null ? (this.cap = new RecordingCapability()) : this.cap;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return CAPABILITY.orEmpty(cap, this.optional);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.getInstance().saveNBTData(nbt);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.getInstance().loadNBTData(nbt);
    }

    public static boolean isRecording(Player player) {
        return RecordingCapabilityProvider.getProp(player, RecordingCapability::isRecording, false);
    }

    public static BlockPos getLooperPos(Player player) {
        return RecordingCapabilityProvider.getProp(player, RecordingCapability::getLooperPos, null);
    }

    public static void setRecording(Player player, BlockPos looperPos) {
        player.getCapability(CAPABILITY).ifPresent(cap -> cap.setRecording(looperPos));
    }

    public static void setNotRecording(Player player) {
        player.getCapability(CAPABILITY).ifPresent(RecordingCapability::setNotRecording);
    }

    private static <T> T getProp(Player player, Function<RecordingCapability, T> ifExists, T elseVal) {
        LazyOptional lazyOpen = player.getCapability(CAPABILITY);
        return lazyOpen.isPresent() ? ifExists.apply((RecordingCapability)lazyOpen.resolve().get()) : elseVal;
    }
}

