/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.block.partial;

import com.cstav.genshinstrument.block.partial.InstrumentBlockEntity;
import com.cstav.genshinstrument.capability.instrumentOpen.InstrumentOpenProvider;
import com.cstav.genshinstrument.client.ModArmPose;
import com.cstav.genshinstrument.networking.GIPacketHandler;
import com.cstav.genshinstrument.networking.packet.instrument.s2c.NotifyInstrumentOpenPacket;
import com.cstav.genshinstrument.networking.packet.instrument.util.InstrumentPacketUtil;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;

public abstract class AbstractInstrumentBlock
extends BaseEntityBlock {
    private Object clientBlockArmPose;

    public AbstractInstrumentBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        if (!FMLEnvironment.dist.isDedicatedServer()) {
            this.initClientBlockUseAnim(pose -> {
                this.clientBlockArmPose = pose;
            });
        }
    }

    protected abstract void onInstrumentOpen(ServerPlayer var1);

    public abstract InstrumentBlockEntity newBlockEntity(BlockPos var1, BlockState var2);

    protected void initClientBlockUseAnim(Consumer<HumanoidModel.ArmPose> consumer) {
        consumer.accept(ModArmPose.PLAYING_BLOCK_INSTRUMENT);
    }

    @OnlyIn(value=Dist.CLIENT)
    public HumanoidModel.ArmPose getClientBlockArmPose() {
        return (HumanoidModel.ArmPose)this.clientBlockArmPose;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_) {
            return InteractionResult.CONSUME;
        }
        BlockEntity be = pLevel.m_7702_(pPos);
        if (!(be instanceof InstrumentBlockEntity)) {
            return InteractionResult.FAIL;
        }
        if (InstrumentPacketUtil.sendOpenPacket((ServerPlayer)pPlayer, this::onInstrumentOpen, pPos)) {
            ((InstrumentBlockEntity)be).users.add(pPlayer.m_20148_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        BlockEntity be = pLevel.m_7702_(pPos);
        if (!(be instanceof InstrumentBlockEntity)) {
            super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
            return;
        }
        InstrumentBlockEntity ibe = (InstrumentBlockEntity)be;
        for (Player player : pLevel.m_6907_()) {
            ibe.users.forEach(user -> {
                InstrumentOpenProvider.setClosed(pLevel.m_46003_(user));
                GIPacketHandler.sendToClient(new NotifyInstrumentOpenPacket((UUID)user), (ServerPlayer)player);
            });
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }
}

