/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.ukelele;

import com.cstav.genshinstrument.client.config.enumType.NoteGridLabel;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.grid.GridInstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButtonRenderer;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteNotation;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.grid.NoteGridButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.label.NoteLabelSupplier;
import com.cstav.genshinstrument.client.gui.screen.instrument.ukelele.UkuleleNoteButtonRenderer;
import com.cstav.genshinstrument.client.gui.screen.instrument.ukelele.UkuleleScreen;
import com.cstav.genshinstrument.sound.GISounds;
import com.cstav.genshinstrument.sound.NoteSound;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class UkuleleNoteButton
extends NoteGridButton {
    private static final List<NoteLabelSupplier> NOTATIONAL_LABELS = Stream.of(NoteGridLabel.NOTE_NAME, NoteGridLabel.DO_RE_MI, NoteGridLabel.FIXED_ABC, NoteGridLabel.FIXED_DO_RE_MI).map(NoteGridLabel::getLabelSupplier).toList();
    private static final List<NoteLabelSupplier> FIXED_LABELS = Stream.of(NoteGridLabel.FIXED_ABC, NoteGridLabel.FIXED_DO_RE_MI).map(NoteGridLabel::getLabelSupplier).toList();

    public UkuleleNoteButton(int row, int column, GridInstrumentScreen instrumentScreen) {
        super(row, column, instrumentScreen);
    }

    public UkuleleScreen ukuleleScreen() {
        return (UkuleleScreen)this.instrumentScreen;
    }

    @Override
    protected NoteButtonRenderer initNoteRenderer() {
        return new UkuleleNoteButtonRenderer(this, () -> this.getLabelTexture());
    }

    @Override
    public NoteNotation getNotation() {
        if (this.ukuleleScreen().isTopRegular()) {
            return super.getNotation();
        }
        if (this.column == 0) {
            return NoteNotation.NONE;
        }
        return super.getNotation();
    }

    @NotNull
    public Component m_6035_() {
        if (this.ukuleleScreen().isTopRegular()) {
            return super.m_6035_();
        }
        if (this.column == 0 && NOTATIONAL_LABELS.contains(this.getLabelSupplier())) {
            return Component.m_237113_((String)this.getChordNameOfRow());
        }
        return super.m_6035_();
    }

    public String getChordNameOfRow() {
        return this.getNoteName();
    }

    @Override
    public NoteSound getSound() {
        if (!this.ukuleleScreen().isTopRegular() || this.column != 0) {
            return super.getSound();
        }
        return GISounds.UKULELE[13];
    }

    @Override
    public int getPitch() {
        if (!this.ukuleleScreen().isTopRegular() || this.column != 0) {
            return super.getPitch();
        }
        int pitchBump = switch (this.row) {
            case 0 -> 1;
            case 1 -> 3;
            case 2 -> 5;
            case 3 -> 6;
            case 4 -> 8;
            case 5 -> 10;
            case 6 -> 12;
            default -> throw new IllegalStateException("Unexpected value: " + this.row);
        };
        return super.getPitch() + pitchBump;
    }
}

