/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.sound;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.config.enumType.InstrumentChannelType;
import com.cstav.genshinstrument.client.util.ClientUtil;
import com.cstav.genshinstrument.event.NoteSoundPlayedEvent;
import com.cstav.genshinstrument.networking.packet.instrument.NoteSoundMetadata;
import com.cstav.genshinstrument.sound.NoteSoundReuslt;
import com.cstav.genshinstrument.sound.registrar.NoteSoundRegistrar;
import com.cstav.genshinstrument.util.LabelUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.ApiStatus;

public class NoteSound {
    public static final SoundSource INSTRUMENT_SOUND_SOURCE = SoundSource.RECORDS;
    public static final double STEREO_RANGE = 5.5;
    public static final double LOCAL_RANGE = 5.5;
    public static final int MIN_PITCH = -LabelUtil.NOTES_PER_SCALE;
    public static final int MAX_PITCH = LabelUtil.NOTES_PER_SCALE;
    public final int index;
    public final ResourceLocation baseSoundLocation;
    public SoundEvent mono;
    public SoundEvent stereo;

    @ApiStatus.Internal
    public NoteSound(int index, ResourceLocation baseSoundLocation) {
        this.index = index;
        this.baseSoundLocation = baseSoundLocation;
    }

    public SoundEvent getMono() {
        return this.mono;
    }

    public boolean hasStereo() {
        return this.stereo != null;
    }

    @Nullable
    public SoundEvent getStereo() {
        return this.stereo;
    }

    public NoteSound[] getSoundsArr() {
        return NoteSoundRegistrar.getSounds(this.baseSoundLocation);
    }

    public NoteSoundReuslt transpose(int amount) {
        int newIndex = amount + this.index;
        NoteSound[] sounds = this.getSoundsArr();
        int delta = newIndex / sounds.length;
        if (delta != 0) {
            if (delta < -1 || delta > 1) {
                return new NoteSoundReuslt(null, delta);
            }
            newIndex += sounds.length * delta;
        }
        return new NoteSoundReuslt(sounds[newIndex], delta);
    }

    @OnlyIn(value=Dist.CLIENT)
    public SoundEvent getByPreference(double playDistSqr) {
        if (!this.hasStereo()) {
            return this.mono;
        }
        InstrumentChannelType preference = (InstrumentChannelType)((Object)ModClientConfigs.CHANNEL_TYPE.get());
        return switch (preference) {
            default -> throw new IncompatibleClassChangeError();
            case InstrumentChannelType.MIXED -> {
                if (NoteSound.metInstrumentVolume() && playDistSqr <= Mth.m_144952_((double)5.5)) {
                    yield this.getStereo();
                }
                yield this.mono;
            }
            case InstrumentChannelType.STEREO -> this.getStereo();
            case InstrumentChannelType.MONO -> this.mono;
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public SoundEvent getByPreference() {
        return this.getByPreference(0.0);
    }

    private static boolean metInstrumentVolume() {
        return Minecraft.m_91087_().f_91066_.m_92147_(INSTRUMENT_SOUND_SOURCE) == 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playFromServer(Optional<Integer> initiatorId, NoteSoundMetadata meta) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        ClientLevel level = minecraft.f_91073_;
        Entity initiator = initiatorId.map(arg_0 -> ((Level)level).m_6815_(arg_0)).orElse(null);
        double playDistSqr = meta.pos().m_252807_().m_82557_(player.m_20182_());
        ClientUtil.stopMusicIfClose(playDistSqr);
        MinecraftForge.EVENT_BUS.post((Event)(initiator == null ? new NoteSoundPlayedEvent((Level)level, this, meta) : new NoteSoundPlayedEvent(initiator, this, meta)));
        if (player.equals((Object)initiator)) {
            return;
        }
        float mcPitch = NoteSound.getPitchByNoteOffset(NoteSound.clampPitch(meta.pitch()));
        this.playLocally(mcPitch, (float)meta.volume() / 100.0f, meta.pos(), playDistSqr);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playLocally(float pitch, float volume, BlockPos pos, double playDistSqr) {
        Minecraft minecraft = Minecraft.m_91087_();
        SoundEvent sound = this.getByPreference(playDistSqr);
        if (playDistSqr > Mth.m_144952_((double)5.5)) {
            minecraft.f_91073_.m_245747_(pos, sound, INSTRUMENT_SOUND_SOURCE, volume, pitch, false);
        } else {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(sound.m_11660_(), INSTRUMENT_SOUND_SOURCE, volume, pitch, SoundInstance.m_235150_(), false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playLocally(float pitch, float volume, BlockPos pos) {
        this.playLocally(pitch, volume, pos, Minecraft.m_91087_().f_91074_.m_20182_().m_82557_(pos.m_252807_()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playLocally(int pitch, float volume, BlockPos pos, double playDistSqr) {
        this.playLocally(NoteSound.getPitchByNoteOffset(NoteSound.clampPitch(pitch)), volume, pos, playDistSqr);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playLocally(int pitch, float volume, BlockPos pos) {
        this.playLocally(NoteSound.getPitchByNoteOffset(NoteSound.clampPitch(pitch)), volume, pos, Minecraft.m_91087_().f_91074_.m_20182_().m_82557_(pos.m_252807_()));
    }

    public static int clampPitch(int pitch) {
        return Mth.m_14045_((int)pitch, (int)MIN_PITCH, (int)MAX_PITCH);
    }

    public static float getPitchByNoteOffset(int pitch) {
        return (float)Math.pow(2.0, (double)pitch / (double)LabelUtil.NOTES_PER_SCALE);
    }

    public void writeToNetwork(FriendlyByteBuf buf) {
        buf.m_130085_(this.baseSoundLocation);
        buf.writeInt(this.index);
    }

    public static NoteSound readFromNetwork(FriendlyByteBuf buf) {
        return NoteSoundRegistrar.getSounds(buf.m_130281_())[buf.readInt()];
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NoteSound)) {
            return false;
        }
        NoteSound other = (NoteSound)obj;
        return this.baseSoundLocation.equals((Object)other.baseSoundLocation) && this.index == other.index;
    }
}

