/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.sound.registrar;

import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.sound.registrar.impl.ChainableNoteSoundRegistrar;
import com.cstav.genshinstrument.sound.registrar.impl.ChainedNoteSoundRegistrar;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

public class NoteSoundRegistrar
extends ChainableNoteSoundRegistrar<NoteSound, NoteSoundRegistrar> {
    public static final String STEREO_SUFFIX = "_stereo";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final HashMap<ResourceLocation, NoteSound[]> SOUNDS_REGISTRY = new HashMap();

    public static NoteSound[] getSounds(ResourceLocation baseSoundName) {
        return SOUNDS_REGISTRY.get(baseSoundName);
    }

    public NoteSoundRegistrar(DeferredRegister<SoundEvent> soundRegistrar, ResourceLocation baseSoundLocation) {
        super(soundRegistrar, baseSoundLocation);
    }

    @Override
    public NoteSoundRegistrar getThis() {
        return this;
    }

    public NoteSoundRegistrar alreadyRegistered() {
        this.paramsMap.put("ALREADY_REGISTERED", true);
        return this.getThis();
    }

    public NoteSoundRegistrar stereo() {
        this.paramsMap.put("HAS_STEREO", true);
        return this.getThis();
    }

    public NoteSound[] register(NoteSound[] noteSounds) {
        SOUNDS_REGISTRY.put(this.baseSoundLocation, noteSounds);
        LOGGER.info("Successfully registered " + noteSounds.length + " note sounds of " + this.baseSoundLocation);
        return noteSounds;
    }

    public NoteSound[] registerGrid(int rows, int columns) {
        NoteSound[] sounds = new NoteSound[rows * columns];
        for (int i = 0; i < sounds.length; ++i) {
            sounds[i] = this.createNote(i);
        }
        return this.register(sounds);
    }

    public NoteSound[] registerGrid() {
        return this.registerGrid(7, 3);
    }

    protected NoteSound createNote(ResourceLocation soundLocation, int index, Map<String, Object> paramMap) {
        NoteSound sound = new NoteSound(index, this.baseSoundLocation);
        this.setSoundField(soundEvent -> {
            sound.mono = soundEvent;
            return sound.mono;
        }, soundLocation);
        if (NoteSoundRegistrar.getBool(paramMap, "HAS_STEREO")) {
            this.setSoundField(soundEvent -> {
                sound.stereo = soundEvent;
                return sound.stereo;
            }, soundLocation.m_266382_(STEREO_SUFFIX));
        }
        return sound;
    }

    protected NoteSound createNote(ResourceLocation soundLocation, int index) {
        return this.createNote(soundLocation, index, this.paramsMap);
    }

    protected void setSoundField(Function<SoundEvent, SoundEvent> fieldConsumer, ResourceLocation soundLocation) {
        if (NoteSoundRegistrar.getBool(this.paramsMap, "ALREADY_REGISTERED")) {
            fieldConsumer.apply((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundLocation));
        } else {
            this.soundRegistrar.register(soundLocation.m_135815_(), () -> (SoundEvent)fieldConsumer.apply(SoundEvent.m_262824_((ResourceLocation)soundLocation)));
        }
    }

    public Chained chain(ResourceLocation soundLocation) {
        return new Chained(soundLocation);
    }

    @Override
    protected IntFunction<NoteSound[]> noteArrayGenerator() {
        return NoteSound[]::new;
    }

    public NoteSound registerNote() {
        return this.createNote(this.baseSoundLocation, 0);
    }

    public NoteSound createNote(int noteIndex) {
        return this.createNote(this.baseSoundLocation.m_266382_("_note_" + noteIndex), noteIndex);
    }

    public final class Chained
    extends ChainedNoteSoundRegistrar<NoteSound, NoteSoundRegistrar> {
        private final ResourceLocation soundLocation;

        public Chained(ResourceLocation soundLocation) {
            super(NoteSoundRegistrar.this.getThis());
            this.soundLocation = soundLocation;
        }

        @Override
        protected NoteSound createNote() {
            return NoteSoundRegistrar.this.createNote(this.soundLocation, NoteSoundRegistrar.this.stackedSounds.size(), NoteSoundRegistrar.this.paramsMap);
        }

        public ChainedNoteSoundRegistrar<NoteSound, NoteSoundRegistrar> alreadyRegistered() {
            NoteSoundRegistrar.this.paramsMap.put("ALREADY_REGISTERED", true);
            return this.getThis();
        }

        public ChainedNoteSoundRegistrar<NoteSound, NoteSoundRegistrar> stereo() {
            NoteSoundRegistrar.this.paramsMap.put("HAS_STEREO", true);
            return this.getThis();
        }
    }
}

