/*
 * Decompiled with CFR 0.152.
 */
package goblinstyranny.network;

import goblinstyranny.GoblinsTyrannyMod;
import goblinstyranny.procedures.CurseforgePageProcedure;
import goblinstyranny.procedures.DiscordServerProcedure;
import goblinstyranny.procedures.OpenGameplayPageProcedure;
import goblinstyranny.procedures.OpenItemsPageProcedure;
import goblinstyranny.procedures.OpenMainPageProcedure;
import goblinstyranny.procedures.OpenMobsPageProcedure;
import goblinstyranny.procedures.OpenRecipesPageProcedure;
import goblinstyranny.procedures.OpenStructuresPageProcedure;
import goblinstyranny.procedures.YoutubeShowcaseProcedure;
import goblinstyranny.procedures.YoutubeTrailerProcedure;
import goblinstyranny.world.inventory.SupportPageMenu;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SupportPageButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public SupportPageButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public SupportPageButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(SupportPageButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(SupportPageButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            SupportPageButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = SupportPageMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            OpenMobsPageProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            OpenItemsPageProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            OpenStructuresPageProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            OpenRecipesPageProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            OpenGameplayPageProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            OpenMainPageProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            DiscordServerProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            CurseforgePageProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            YoutubeTrailerProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            YoutubeShowcaseProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        GoblinsTyrannyMod.addNetworkMessage(SupportPageButtonMessage.class, SupportPageButtonMessage::buffer, SupportPageButtonMessage::new, SupportPageButtonMessage::handler);
    }
}

