/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.client.particle;

import com.github.alexthe668.iwannaskate.client.model.HoverParticleModel;
import com.github.alexthe668.iwannaskate.client.render.IWSRenderTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HoverParticle
extends Particle {
    private static final ResourceLocation TEXTURE = new ResourceLocation("iwannaskate", "textures/particle/hover.png");
    private static final RenderType HOVER_RENDER_TYPE = IWSRenderTypes.getHover(TEXTURE);
    private static final HoverParticleModel MODEL = new HoverParticleModel();
    private float size;
    private float prevSize;
    private float prevAlpha;
    private float alphaDecrease;
    private double yaw;
    private double pitch;
    private double prevPitch;

    private HoverParticle(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z);
        this.m_107250_(1.0f, 0.1f);
        this.f_107230_ = 1.0f;
        this.f_107226_ = 0.02f;
        this.f_107215_ = 0.0;
        this.f_107216_ = motionY;
        this.f_107217_ = 0.0;
        this.yaw = motionX;
        this.pitch = motionZ * 90.0;
        this.f_107225_ = 7;
        this.alphaDecrease = 1.0f / Math.max((float)this.f_107225_, 1.0f);
        this.size = 1.0f;
    }

    public void m_5989_() {
        super.m_5989_();
        this.prevSize = this.size;
        this.prevAlpha = this.f_107230_;
        this.prevPitch = this.pitch;
        this.f_107215_ *= 0.8;
        this.f_107216_ *= 0.8;
        this.f_107217_ *= 0.8;
        if (this.f_107230_ > 0.0f) {
            this.f_107230_ = Math.max(this.f_107230_ - this.alphaDecrease, 0.0f);
        }
        if (this.size > 0.5f) {
            this.size -= 0.1f;
        }
        if (this.pitch > 0.0) {
            this.pitch = Math.max(0.0, this.pitch - 5.0);
        }
        if (this.pitch < 0.0) {
            this.pitch = Math.min(0.0, this.pitch + 5.0);
        }
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTick) {
        float colorMod;
        Vec3 vec3 = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        float alphaLerp = this.prevAlpha + partialTick * (this.f_107230_ - this.prevAlpha);
        float sizeLerp = this.prevSize + partialTick * (this.size - this.prevSize);
        double pitchLerp = this.prevPitch + (double)partialTick * (this.pitch - this.prevPitch);
        float r = colorMod = 1.0f - (sizeLerp * 2.0f - 1.0f);
        float g = 0.75f + colorMod * 0.25f;
        float b = 0.95f + colorMod * 0.05f;
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer vertexConsumer1 = multibuffersource$buffersource.m_6299_(HOVER_RENDER_TYPE);
        PoseStack posestack = new PoseStack();
        posestack.m_252880_(f, f1, f2);
        posestack.m_252781_(Axis.f_252392_.m_252977_((float)this.yaw));
        posestack.m_252781_(Axis.f_252529_.m_252977_((float)pitchLerp));
        posestack.m_85841_(sizeLerp, sizeLerp, sizeLerp);
        int j = 240;
        MODEL.m_7695_(posestack, vertexConsumer1, j, OverlayTexture.f_118083_, r, g, b, alphaLerp);
        multibuffersource$buffersource.m_109911_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new HoverParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

