/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.compat.jei;

import com.github.alexthe668.iwannaskate.server.item.IWSItemRegistry;
import com.github.alexthe668.iwannaskate.server.item.SkateboardData;
import com.github.alexthe668.iwannaskate.server.item.SkateboardMaterials;
import com.github.alexthe668.iwannaskate.server.item.SkateboardWheels;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraftforge.registries.ForgeRegistries;

public class IWSRecipeMaker {
    public static List<CraftingRecipe> createDeckRecipes() {
        return SkateboardMaterials.getSkateboardMaterials().stream().map(woodItem -> IWSRecipeMaker.createDeckRecipe(woodItem)).toList();
    }

    public static List<CraftingRecipe> createSkateboardRecipes() {
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        SkateboardMaterials.getSkateboardMaterials().stream().forEach(woodItem -> recipes.addAll(IWSRecipeMaker.createSkateboardRecipesForDeck(woodItem)));
        return recipes;
    }

    public static List<CraftingRecipe> createSkateboardBannerRecipes() {
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        SkateboardMaterials.getSkateboardMaterials().stream().forEach(woodItem -> recipes.addAll(IWSRecipeMaker.createSkateboardBannerRecipes(woodItem)));
        return recipes;
    }

    public static List<CraftingRecipe> createSkateboardGripRecipes() {
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        SkateboardMaterials.getSkateboardMaterials().stream().forEach(woodItem -> recipes.addAll(IWSRecipeMaker.createSkateboardGripRecipes(woodItem)));
        return recipes;
    }

    private static List<CraftingRecipe> createSkateboardBannerRecipes(Item woodItem) {
        String group = "jei.skateboard_deck";
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        ItemStack input = IWSRecipeMaker.createSkateboardForWood(woodItem);
        for (Item banner : SkateboardMaterials.getBanners()) {
            if (!(banner instanceof BannerItem)) continue;
            ItemStack output = input.m_41777_();
            SkateboardData data = SkateboardData.fromStack(input);
            CompoundTag bannerTag = new CompoundTag();
            bannerTag.m_128405_("Base", ((BannerItem)banner).m_40545_().m_41060_());
            data.setBanner(bannerTag);
            SkateboardData.setStackData(output, data);
            ResourceLocation id = new ResourceLocation("iwannaskate", "jei.skateboard_banner_" + ForgeRegistries.ITEMS.getKey((Object)woodItem).m_135815_() + banner.m_5524_());
            NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{input}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{banner})});
            recipes.add((CraftingRecipe)new ShapelessRecipe(id, group, CraftingBookCategory.MISC, output, inputs));
        }
        return recipes;
    }

    private static List<CraftingRecipe> createSkateboardGripRecipes(Item woodItem) {
        String group = "jei.skateboard_deck";
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        ItemStack input = IWSRecipeMaker.createSkateboardForWood(woodItem);
        for (Item carpet : SkateboardMaterials.getGrips()) {
            Block block = Block.m_49814_((Item)carpet);
            if (!(block instanceof WoolCarpetBlock)) continue;
            WoolCarpetBlock carpetBlock = (WoolCarpetBlock)block;
            ItemStack output = input.m_41777_();
            SkateboardData data = SkateboardData.fromStack(input);
            data.setGripTape(carpetBlock.m_58309_());
            SkateboardData.setStackData(output, data);
            ResourceLocation id = new ResourceLocation("iwannaskate", "jei.skateboard_grip_" + ForgeRegistries.ITEMS.getKey((Object)woodItem).m_135815_() + carpet.m_5524_());
            NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{input}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{carpet})});
            recipes.add((CraftingRecipe)new ShapelessRecipe(id, group, CraftingBookCategory.MISC, output, inputs));
        }
        return recipes;
    }

    private static CraftingRecipe createDeckRecipe(Item deckMaterial) {
        String group = "jei.skateboard_deck";
        ItemStack input = new ItemStack((ItemLike)deckMaterial);
        ItemStack output = IWSRecipeMaker.createDeckForWood(deckMaterial);
        Ingredient woodIngredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{input});
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.f_43901_, Ingredient.f_43901_, woodIngredient, Ingredient.f_43901_, woodIngredient, Ingredient.f_43901_, woodIngredient, Ingredient.f_43901_, Ingredient.f_43901_});
        ResourceLocation id = new ResourceLocation("iwannaskate", "jei.skateboard_deck_" + ForgeRegistries.ITEMS.getKey((Object)deckMaterial).m_135815_());
        return new ShapedRecipe(id, group, CraftingBookCategory.MISC, 3, 3, inputs, output);
    }

    private static List<CraftingRecipe> createSkateboardRecipesForDeck(Item woodItem) {
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        String group = "jei.skateboard";
        for (Item wheel : SkateboardMaterials.getSkateboardWheels()) {
            ItemStack output = new ItemStack((ItemLike)IWSItemRegistry.SKATEBOARD.get());
            SkateboardData data = new SkateboardData(ForgeRegistries.ITEMS.getKey((Object)woodItem));
            data.setWheelType(SkateboardWheels.fromItem(wheel));
            SkateboardData.setStackData(output, data);
            Ingredient deckIngredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{IWSRecipeMaker.createDeckForWood(woodItem)});
            Ingredient truckIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)IWSItemRegistry.SKATEBOARD_TRUCK.get()});
            Ingredient wheelIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{wheel});
            NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.f_43901_, Ingredient.f_43901_, Ingredient.f_43901_, truckIngredient, deckIngredient, truckIngredient, wheelIngredient, Ingredient.f_43901_, wheelIngredient});
            ResourceLocation id = new ResourceLocation("iwannaskate", "jei.skateboard_" + ForgeRegistries.ITEMS.getKey((Object)woodItem).m_135815_());
            recipes.add((CraftingRecipe)new ShapedRecipe(id, group, CraftingBookCategory.MISC, 3, 3, inputs, output));
        }
        return recipes;
    }

    private static ItemStack createDeckForWood(Item deck) {
        ItemStack stack = new ItemStack((ItemLike)IWSItemRegistry.SKATEBOARD_DECK.get());
        SkateboardData data = new SkateboardData(ForgeRegistries.ITEMS.getKey((Object)deck));
        SkateboardData.setStackData(stack, data);
        return stack;
    }

    private static ItemStack createSkateboardForWood(Item deck) {
        ItemStack stack = new ItemStack((ItemLike)IWSItemRegistry.SKATEBOARD.get());
        SkateboardData data = new SkateboardData(ForgeRegistries.ITEMS.getKey((Object)deck));
        SkateboardData.setStackData(stack, data);
        return stack;
    }
}

