/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.blockentity;

import com.github.alexthe668.iwannaskate.IWannaSkateMod;
import com.github.alexthe668.iwannaskate.server.block.SkateboardRackBlock;
import com.github.alexthe668.iwannaskate.server.blockentity.IWSBlockEntityRegistry;
import com.github.alexthe668.iwannaskate.server.item.BaseSkateboardItem;
import com.github.alexthe668.iwannaskate.server.network.SkateboardRackMessage;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class SkateboardRackBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN});
    private NonNullList<ItemStack> stacks = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private int tickCount;
    private int lastHoverTimestamp = -1;
    private boolean mouseOverTop = false;
    private int topHoverProgress;
    private int prevTopHoverProgress;
    private int bottomHoverProgress;
    private int prevBottomHoverProgress;

    public SkateboardRackBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IWSBlockEntityRegistry.SKATEBOARD_RACK.get(), pos, state);
    }

    public static void commonTick(Level level, BlockPos pos, BlockState state, SkateboardRackBlockEntity entity) {
        boolean bottom;
        ++entity.tickCount;
        entity.prevTopHoverProgress = entity.topHoverProgress;
        entity.prevBottomHoverProgress = entity.bottomHoverProgress;
        boolean currentlyHovering = entity.lastHoverTimestamp > 0 && Math.abs(entity.tickCount - entity.lastHoverTimestamp) < 2;
        boolean top = currentlyHovering && entity.mouseOverTop;
        boolean bl = bottom = currentlyHovering && !entity.mouseOverTop;
        if (top && (float)entity.topHoverProgress < 3.0f) {
            ++entity.topHoverProgress;
        }
        if (!top && (float)entity.topHoverProgress > 0.0f) {
            --entity.topHoverProgress;
        }
        if (bottom && (float)entity.bottomHoverProgress < 3.0f) {
            ++entity.bottomHoverProgress;
        }
        if (!bottom && (float)entity.bottomHoverProgress > 0.0f) {
            --entity.bottomHoverProgress;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_.m_7918_(-1, 0, -1), this.f_58858_.m_7918_(2, 2, 2));
    }

    public float getHoverOver(boolean top, float partialTick) {
        float f = top ? (float)this.prevTopHoverProgress + (float)(this.topHoverProgress - this.prevTopHoverProgress) * partialTick : (float)this.prevBottomHoverProgress + (float)(this.bottomHoverProgress - this.prevBottomHoverProgress) * partialTick;
        return f / 3.0f;
    }

    public int m_6643_() {
        return this.stacks.size();
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.stacks.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        if (!((ItemStack)this.stacks.get(index)).m_41619_()) {
            if (((ItemStack)this.stacks.get(index)).m_41613_() <= count) {
                ItemStack itemstack = (ItemStack)this.stacks.get(index);
                this.stacks.set(index, (Object)ItemStack.f_41583_);
                return itemstack;
            }
            ItemStack itemstack = ((ItemStack)this.stacks.get(index)).m_41620_(count);
            if (((ItemStack)this.stacks.get(index)).m_41619_()) {
                this.stacks.set(index, (Object)ItemStack.f_41583_);
            }
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getStackInSlotOnClosing(int index) {
        if (!((ItemStack)this.stacks.get(index)).m_41619_()) {
            ItemStack itemstack = (ItemStack)this.stacks.get(index);
            this.stacks.set(index, (Object)itemstack);
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    public void m_6836_(int index, ItemStack stack) {
        boolean flag = !stack.m_41619_() && ItemStack.m_41656_((ItemStack)stack, (ItemStack)((ItemStack)this.stacks.get(index))) && ItemStack.m_150942_((ItemStack)stack, (ItemStack)((ItemStack)this.stacks.get(index)));
        this.stacks.set(index, (Object)stack);
        if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_183515_(this.m_5995_());
        if (!this.f_58857_.f_46443_) {
            IWannaSkateMod.sendMSGToAll(new SkateboardRackMessage(this.m_58899_().m_121878_(), index, (ItemStack)this.stacks.get(index)));
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.stacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compound, this.stacks);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        ContainerHelper.m_18973_((CompoundTag)compound, this.stacks);
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public boolean m_7155_(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public int m_6893_() {
        return 1;
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_6211_() {
        this.stacks.clear();
    }

    public int[] m_7071_(Direction side) {
        return new int[]{0, 1};
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public boolean m_8077_() {
        return false;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return stack.m_41720_() instanceof BaseSkateboardItem;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        if (packet != null && packet.m_131708_() != null) {
            this.stacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)packet.m_131708_(), this.stacks);
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public ItemStack m_8016_(int index) {
        ItemStack lvt_2_1_ = (ItemStack)this.stacks.get(index);
        if (lvt_2_1_.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.stacks.set(index, (Object)ItemStack.f_41583_);
        return lvt_2_1_;
    }

    public Component m_5446_() {
        return this.m_6820_();
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"block.alexsmobs.capsid");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return null;
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public Direction getBlockAngle() {
        if (this.m_58900_().m_60734_() instanceof SkateboardRackBlock) {
            return (Direction)this.m_58900_().m_61143_((Property)SkateboardRackBlock.FACING);
        }
        return Direction.NORTH;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.DOWN) {
                return this.handlers[0].cast();
            }
            return this.handlers[1].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void onHoverOver(Entity entity) {
        BlockHitResult blockHitResult;
        HitResult result = this.raytraceCarefully(entity, 15.0, 1.0f, true);
        if (result instanceof BlockHitResult && (blockHitResult = (BlockHitResult)result).m_82425_().equals((Object)this.m_58899_())) {
            Vec3 vec3 = result.m_82450_().m_82546_(Vec3.m_82512_((Vec3i)this.m_58899_()));
            this.mouseOverTop = vec3.f_82480_ >= 0.0;
            this.lastHoverTimestamp = this.tickCount;
        }
    }

    public HitResult raytraceCarefully(Entity entity, double rayTraceDistance, float partialTicks, boolean rayTraceFluids) {
        Vec3 vector3d = entity.m_20299_(partialTicks);
        Vec3 vector3d1 = entity.m_20252_(partialTicks);
        Vec3 vector3d2 = vector3d.m_82520_(vector3d1.f_82479_ * rayTraceDistance, vector3d1.f_82480_ * rayTraceDistance, vector3d1.f_82481_ * rayTraceDistance);
        return this.f_58857_.m_45547_(new ClipContext(vector3d, vector3d2, ClipContext.Block.VISUAL, rayTraceFluids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, entity));
    }
}

