/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.item;

import com.github.alexthe666.citadel.item.ItemWithHoverAnimation;
import com.github.alexthe668.iwannaskate.IWannaSkateMod;
import com.github.alexthe668.iwannaskate.server.item.CustomTabBehavior;
import com.github.alexthe668.iwannaskate.server.item.IWSItemRegistry;
import com.github.alexthe668.iwannaskate.server.item.SkateboardData;
import com.github.alexthe668.iwannaskate.server.item.SkateboardMaterials;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;

public class BaseSkateboardItem
extends Item
implements ItemWithHoverAnimation,
CustomTabBehavior {
    private final ImmutableMultimap<Attribute, AttributeModifier> weaponModifiers;

    public BaseSkateboardItem(Item.Properties properties) {
        super(properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 2.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)-3.2f, AttributeModifier.Operation.ADDITION));
        this.weaponModifiers = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.weaponModifiers : super.m_7167_(slot);
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output contents) {
        SkateboardMaterials.getSkateboardMaterials().forEach(item -> this.addBoardToTab(contents, this, (Item)item));
    }

    public void addBoardToTab(CreativeModeTab.Output contents, Item board, Item material) {
        ItemStack stack = new ItemStack((ItemLike)board);
        SkateboardData data = new SkateboardData(ForgeRegistries.ITEMS.getKey((Object)material));
        SkateboardData.setStackData(stack, data);
        contents.m_246342_(stack);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)IWannaSkateMod.PROXY.getISTERProperties());
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        SkateboardData.fromStack(stack).appendHoverText(tooltip, stack);
    }

    public boolean canFlipInInventory(ItemStack stack) {
        return false;
    }

    public boolean m_6832_(ItemStack stack1, ItemStack stack2) {
        return stack2.m_150930_((Item)IWSItemRegistry.SKATEBOARD_TRUCK.get());
    }

    public boolean m_5812_(ItemStack stack) {
        return super.m_5812_(stack) && (stack.m_41783_() == null || !stack.m_41783_().m_128471_("RemovedShimmer"));
    }

    public float getMaxHoverOverTime(ItemStack itemStack) {
        return 5.0f;
    }

    public boolean canHoverOver(ItemStack itemStack) {
        return false;
    }
}

