/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.network;

import com.github.alexthe668.iwannaskate.IWannaSkateMod;
import com.github.alexthe668.iwannaskate.server.entity.SkateboardEntity;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SkateboardPartMessage {
    public int parentId;
    public int playerId;
    public int type;

    public SkateboardPartMessage(int parentId, int playerId, int type) {
        this.parentId = parentId;
        this.playerId = playerId;
        this.type = type;
    }

    public SkateboardPartMessage() {
    }

    public static SkateboardPartMessage read(FriendlyByteBuf buf) {
        return new SkateboardPartMessage(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void write(SkateboardPartMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.parentId);
        buf.writeInt(message.playerId);
        buf.writeInt(message.type);
    }

    public static class Handler {
        public static void handle(SkateboardPartMessage message, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                SkateboardEntity skateboard;
                ServerPlayer playerSided = ((NetworkEvent.Context)context.get()).getSender();
                if (((NetworkEvent.Context)context.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                    playerSided = IWannaSkateMod.PROXY.getClientSidePlayer();
                }
                Entity parent = playerSided.m_9236_().m_6815_(message.parentId);
                Entity interacter = playerSided.m_9236_().m_6815_(message.playerId);
                if (interacter != null && parent instanceof SkateboardEntity && interacter.m_20270_((Entity)(skateboard = (SkateboardEntity)parent)) < 16.0f) {
                    skateboard.onInteractPacket(interacter, message.type);
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

