/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.recipe;

import com.github.alexthe666.citadel.recipe.SpecialRecipeInGuideBook;
import com.github.alexthe668.iwannaskate.server.item.IWSItemRegistry;
import com.github.alexthe668.iwannaskate.server.item.SkateboardData;
import com.github.alexthe668.iwannaskate.server.recipe.IWSRecipeRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RecipeSkateboardBanner
extends CustomRecipe
implements SpecialRecipeInGuideBook {
    public RecipeSkateboardBanner(ResourceLocation name, CraftingBookCategory category) {
        super(name, category);
    }

    public boolean matches(CraftingContainer craftingContainer, Level level) {
        ItemStack skateboard = ItemStack.f_41583_;
        ItemStack bannerStack = ItemStack.f_41583_;
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            ItemStack itemstack2 = craftingContainer.m_8020_(i);
            if (itemstack2.m_41619_()) continue;
            if (itemstack2.m_41720_() instanceof BannerItem) {
                if (!bannerStack.m_41619_()) {
                    return false;
                }
                bannerStack = itemstack2;
                continue;
            }
            if (!itemstack2.m_150930_((Item)IWSItemRegistry.SKATEBOARD.get())) {
                return false;
            }
            if (!skateboard.m_41619_()) {
                return false;
            }
            if (SkateboardData.fromStack(itemstack2).hasBanner()) {
                return false;
            }
            skateboard = itemstack2;
        }
        return !skateboard.m_41619_() && !bannerStack.m_41619_();
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack banner = ItemStack.f_41583_;
        ItemStack skateboard = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemstack2 = container.m_8020_(i);
            if (itemstack2.m_41619_()) continue;
            if (itemstack2.m_41720_() instanceof BannerItem) {
                banner = itemstack2;
                continue;
            }
            if (!itemstack2.m_150930_((Item)IWSItemRegistry.SKATEBOARD.get())) continue;
            skateboard = itemstack2.m_41777_();
        }
        if (skateboard.m_41619_()) {
            return skateboard;
        }
        CompoundTag compoundtag = BlockItem.m_186336_((ItemStack)banner);
        CompoundTag compoundtag1 = compoundtag == null ? new CompoundTag() : compoundtag.m_6426_();
        compoundtag1.m_128405_("Base", ((BannerItem)banner.m_41720_()).m_40545_().m_41060_());
        SkateboardData data = SkateboardData.fromStack(skateboard);
        data.setBanner(compoundtag1);
        SkateboardData.setStackData(skateboard, data);
        return skateboard;
    }

    public boolean m_8004_(int x, int y) {
        return x * y >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)IWSRecipeRegistry.SKATEBOARD_BANNER.get();
    }

    public NonNullList<Ingredient> getDisplayIngredients() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)IWSItemRegistry.SKATEBOARD.get()}), Ingredient.m_204132_((TagKey)ItemTags.f_13191_)});
    }

    public ItemStack getDisplayResultFor(NonNullList<ItemStack> nonNullList) {
        ItemStack banner = ItemStack.f_41583_;
        ItemStack skateboard = ItemStack.f_41583_;
        for (int i = 0; i < nonNullList.size(); ++i) {
            ItemStack itemstack2 = (ItemStack)nonNullList.get(i);
            if (itemstack2.m_41619_()) continue;
            if (itemstack2.m_41720_() instanceof BannerItem) {
                banner = itemstack2;
                continue;
            }
            if (!itemstack2.m_150930_((Item)IWSItemRegistry.SKATEBOARD.get())) continue;
            skateboard = itemstack2.m_41777_();
        }
        if (skateboard.m_41619_()) {
            return skateboard;
        }
        CompoundTag compoundtag = BlockItem.m_186336_((ItemStack)banner);
        CompoundTag compoundtag1 = compoundtag == null ? new CompoundTag() : compoundtag.m_6426_();
        compoundtag1.m_128405_("Base", ((BannerItem)banner.m_41720_()).m_40545_().m_41060_());
        SkateboardData data = SkateboardData.fromStack(skateboard);
        data.setBanner(compoundtag1);
        SkateboardData.setStackData(skateboard, data);
        return skateboard;
    }
}

