/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.version;

import com.google.common.base.Joiner;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Arrays;
import journeymap.common.Journeymap;
import journeymap.common.network.data.Side;
import org.apache.logging.log4j.util.Strings;

public class Version
implements Comparable<Version> {
    private static final String DIGIT_NUMBER_SPLIT_MATCHER = "(?<=\\D)(?=\\d)";
    private static final String DIGIT_PATCH_VERSION_SPLIT_MATCHER = "(?<=\\d)(?=\\p{L})";
    public final int major;
    public final int minor;
    public final int micro;
    public final String patch;
    public String loader;
    public String loaderVersion;
    public String minecraftVersion;

    public Version(int major, int minor, int micro) {
        this(major, minor, micro, "");
    }

    public Version(int major, int minor, int micro, String patch2) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.patch = patch2 != null ? patch2 : "";
    }

    public static Version from(String major, String minor, String micro, String patch2, Version defaultVersion) {
        Version result = null;
        try {
            if (!major.contains("@")) {
                result = new Version(Version.parseInt(major), Version.parseInt(minor), Version.parseInt(micro), patch2);
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().warn(String.format("Version had problems when parsed: %s, %s, %s, %s", major, minor, micro, patch2));
        }
        if (result == null) {
            if (defaultVersion == null) {
                defaultVersion = new Version(0, 0, 0);
            }
            result = defaultVersion;
        }
        return result;
    }

    public static Version from(String versionString, Version defaultVersion) {
        try {
            String patch2;
            String[] strings = versionString.split(DIGIT_PATCH_VERSION_SPLIT_MATCHER);
            String[] majorMinorMicro = strings[0].split("\\.");
            String string = patch2 = strings.length == 2 ? strings[1] : "";
            if (majorMinorMicro.length < 3) {
                majorMinorMicro = Arrays.copyOf(strings, 3);
            }
            return Version.from(majorMinorMicro[0], majorMinorMicro[1], majorMinorMicro[2], patch2, defaultVersion);
        }
        catch (Exception e) {
            Journeymap.getLogger().warn(String.format("Version had problems when parsed: %s", versionString));
            if (defaultVersion == null) {
                defaultVersion = new Version(0, 0, 0);
            }
            return defaultVersion;
        }
    }

    private static int parseInt(String number) {
        if (number == null) {
            return 0;
        }
        return Integer.parseInt(number);
    }

    public String toMajorMinorString() {
        return Joiner.on((String)".").join((Object)this.major, (Object)this.minor, new Object[0]);
    }

    public String toMajorMinorMicroString() {
        return Joiner.on((String)".").join((Object)this.major, (Object)this.minor, new Object[]{this.micro});
    }

    public boolean isNewerThan(Version other) {
        return this.compareTo(other) > 0;
    }

    public boolean isRelease() {
        return Strings.isEmpty((CharSequence)this.patch);
    }

    public String toString() {
        return Joiner.on((String)".").join((Object)this.major, (Object)this.minor, new Object[]{this.micro + this.patch});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        if (this.major != version.major) {
            return false;
        }
        if (this.micro != version.micro) {
            return false;
        }
        if (this.minor != version.minor) {
            return false;
        }
        return this.patch.equals(version.patch);
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.micro;
        result = 31 * result + this.patch.hashCode();
        return result;
    }

    @Override
    public int compareTo(Version other) {
        int result = Integer.compare(this.major, other.major);
        if (result == 0) {
            result = Integer.compare(this.minor, other.minor);
        }
        if (result == 0) {
            result = Integer.compare(this.micro, other.micro);
        }
        if (result == 0 && (result = this.patch.compareToIgnoreCase(other.patch)) != 0) {
            result = this.comparePatchVersion(other);
        }
        return result;
    }

    private int comparePatchVersion(Version other) {
        if (this.patch.equals("") && other.patchInt() == 3) {
            return -1;
        }
        if (other.patch.equals("") && this.patchInt() == 3) {
            return 1;
        }
        if (this.patch.equals("")) {
            return 1;
        }
        if (other.patch.equals("")) {
            return -1;
        }
        int result = Integer.compare(this.patchInt(), other.patchInt());
        if (result == 0) {
            if (other.patchSplit().length > 1 && this.patchSplit().length > 1) {
                return Integer.compare(this.patchVersion(), other.patchVersion());
            }
            return Integer.compare(this.patchSplit().length, other.patchSplit().length);
        }
        return result;
    }

    private int patchVersion() {
        return Integer.parseInt(this.patchSplit()[1]);
    }

    private String patchText() {
        return this.patchSplit()[0];
    }

    private String[] patchSplit() {
        return this.patch.replace(".jar", "").split(DIGIT_NUMBER_SPLIT_MATCHER);
    }

    private int patchInt() {
        switch (this.patchText()) {
            case "a": 
            case "alpha": {
                return 0;
            }
            case "b": 
            case "beta": {
                return 1;
            }
            case "rc": {
                return 2;
            }
            case "p": {
                return 3;
            }
            case "dev": {
                return 4;
            }
        }
        return -1;
    }

    public String toJson() {
        JsonObject version = new JsonObject();
        JsonObject node = new JsonObject();
        node.addProperty("full", this.toString());
        node.addProperty("major", (Number)this.major);
        node.addProperty("minor", (Number)this.minor);
        node.addProperty("micro", (Number)this.micro);
        node.addProperty("patch", this.isRelease() ? null : this.patch);
        version.add("journeymap_version", (JsonElement)node);
        version.addProperty("loader_version", Journeymap.LOADER_VERSION);
        version.addProperty("loader", Journeymap.LOADER_NAME);
        version.addProperty("minecraft_version", Journeymap.MC_VERSION);
        return version.toString();
    }

    public static Version fromJson(String string) {
        JsonObject node = (JsonObject)JsonParser.parseString((String)string);
        JsonObject versions = node.get("journeymap_version").getAsJsonObject();
        String full = versions.get("full").getAsString();
        Version version = Version.from(full, null);
        version.loaderVersion = node.get("loader_version").getAsString();
        version.loader = node.get("loader").getAsString();
        version.minecraftVersion = node.get("minecraft_version").getAsString();
        return version;
    }

    public boolean isValid(Version min, Side side) {
        if (Journeymap.DEV_VERSION.equals(this)) {
            Journeymap.getLogger().info("Dev Mode? " + this + " " + Journeymap.JM_VERSION);
            return true;
        }
        if (min.isNewerThan(this)) {
            Journeymap.getLogger().info("Version Mismatch need at least " + min + " or higher. Current " + side.opposite() + " version attempt -> " + this);
            return false;
        }
        return true;
    }
}

