/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.ingredients.subtypes;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.ItemStack;

public class SuspiciousStewSubtypeInterpreter
implements IIngredientSubtypeInterpreter<ItemStack> {
    public static final SuspiciousStewSubtypeInterpreter INSTANCE = new SuspiciousStewSubtypeInterpreter();

    private SuspiciousStewSubtypeInterpreter() {
    }

    @Override
    public String apply(ItemStack itemStack, UidContext context) {
        List<String> strings = SuspiciousStewSubtypeInterpreter.getPotionEffectStrings(itemStack);
        if (strings.isEmpty()) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(",", "[", "]");
        strings.sort(null);
        for (String s : strings) {
            joiner.add(s);
        }
        return joiner.toString();
    }

    private static List<String> getPotionEffectStrings(ItemStack itemStack) {
        ArrayList<String> effects = new ArrayList<String>();
        CompoundTag compoundtag = itemStack.m_41783_();
        if (compoundtag != null && compoundtag.m_128425_("Effects", 9)) {
            ListTag effectsTag = compoundtag.m_128437_("Effects", 10);
            for (int i = 0; i < effectsTag.size(); ++i) {
                CompoundTag effectTag = effectsTag.m_128728_(i);
                int duration = effectTag.m_128425_("EffectDuration", 99) ? effectTag.m_128451_("EffectDuration") : 160;
                int effectId = effectTag.m_128451_("EffectId");
                effects.add(effectId + "." + duration);
            }
        }
        return effects;
    }
}

