/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import ru.magistu.siegemachines.client.renderer.MachineGeoRenderer;
import ru.magistu.siegemachines.client.renderer.model.MachineModel;
import ru.magistu.siegemachines.entity.machine.Trebuchet;
import software.bernie.geckolib.cache.object.BakedGeoModel;

public class TrebuchetGeoRenderer
extends MachineGeoRenderer<Trebuchet> {
    public TrebuchetGeoRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new MachineModel("trebuchet"));
    }

    public RenderType getRenderType(Trebuchet animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.m_110473_((ResourceLocation)this.m_5478_((Entity)animatable));
    }

    public void preRender(PoseStack poseStack, Trebuchet animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        Optional projectile = model.getBone("Cobblestone");
        int projectilesize = (animatable.state == Trebuchet.State.IDLE_RELOADED || animatable.shootingticks > 0) && animatable.hasAmmo() ? 1 : 0;
        projectile.ifPresent(bone -> bone.setScaleX((float)projectilesize));
        projectile.ifPresent(bone -> bone.setScaleY((float)projectilesize));
        projectile.ifPresent(bone -> bone.setScaleZ((float)projectilesize));
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public boolean shouldRender(Trebuchet animatable, Frustum camera, double camx, double camy, double camz) {
        if (!animatable.m_6000_(camx, camy, camz)) {
            return false;
        }
        if (animatable.f_19811_) {
            return true;
        }
        AABB aabb = animatable.m_6921_().m_82400_(10.0);
        if (aabb.m_82392_() || aabb.m_82309_() == 0.0) {
            aabb = new AABB(animatable.m_20185_() - 2.0, animatable.m_20186_() - 2.0, animatable.m_20189_() - 2.0, animatable.m_20185_() + 2.0, animatable.m_20186_() + 2.0, animatable.m_20189_() + 2.0);
        }
        return camera.m_113029_(aabb);
    }
}

