/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.machine;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import ru.magistu.siegemachines.api.enitity.Useable;
import ru.magistu.siegemachines.client.SoundTypes;
import ru.magistu.siegemachines.entity.Breakdown;
import ru.magistu.siegemachines.entity.machine.Machine;
import ru.magistu.siegemachines.entity.machine.MachineType;
import ru.magistu.siegemachines.item.ModItems;
import ru.magistu.siegemachines.network.PacketHandler;
import ru.magistu.siegemachines.network.PacketMachineUse;
import ru.magistu.siegemachines.network.PacketMachineUseRelease;
import ru.magistu.siegemachines.util.CartesianGeometry;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BatteringRam
extends Machine
implements GeoAnimatable {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    static RawAnimation MOVING_ANIM = RawAnimation.begin().thenLoop("Moving");
    static RawAnimation HITTING_ANIM = RawAnimation.begin().thenLoop("Hitting");
    static RawAnimation RELOADING_ANIM = RawAnimation.begin().thenLoop("Reloading");
    public int hittingticks = 0;
    private int wheelssoundticks = 10;
    public State state = State.RELOADING;
    private double wheelspitch = 0.0;
    private double wheelsspeed = 0.0;

    public BatteringRam(EntityType<? extends Mob> entitytype, Level level) {
        super(entitytype, level, MachineType.BATTERING_RAM);
    }

    private PlayState wheels_predicate(AnimationState<BatteringRam> event) {
        event.getController().setAnimation(MOVING_ANIM);
        return PlayState.CONTINUE;
    }

    private PlayState reloading_predicate(AnimationState<BatteringRam> event) {
        switch (this.state) {
            case HITTING: {
                event.getController().setAnimation(HITTING_ANIM);
                return PlayState.CONTINUE;
            }
            case RELOADING: {
                event.getController().setAnimation(RELOADING_ANIM);
                return PlayState.CONTINUE;
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController wheels_controller = new AnimationController((GeoAnimatable)this, "wheels_controller", 1, this::wheels_predicate);
        wheels_controller.setOverrideEasingType(dbl -> t -> {
            double d = this.getWheelsSpeed();
            this.wheelsspeed = d > 0.0 ? Math.min(d, 1.0) : Math.max(d, -1.0);
            return this.wheelspitch += 0.015 * this.wheelsspeed;
        });
        data.add(new AnimationController[]{wheels_controller});
        AnimationController reloading_controller = new AnimationController((GeoAnimatable)this, "controller", 1, this::reloading_predicate);
        reloading_controller.setOverrideEasingType(dbl -> t -> {
            if (this.state.equals((Object)State.RELOADING)) {
                return (double)((Integer)this.f_19847_.specs.delaytime.get() - this.delayticks) / (double)((Integer)this.f_19847_.specs.delaytime.get()).intValue();
            }
            return t;
        });
        data.add(new AnimationController[]{reloading_controller});
    }

    public double getTick(Object entity) {
        return this.f_19797_;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.m_9236_().m_5776_() && !this.m_20160_()) {
            player.m_20329_((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_7023_(Vec3 pos) {
        if (this.m_6084_()) {
            if (this.m_20160_()) {
                LivingEntity livingentity = this.m_6688_();
                this.setYawDest(livingentity.m_146908_());
                this.updateYaw();
                float f1 = livingentity.f_20902_;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                this.m_7910_(0.04f);
                pos = new Vec3(0.0, pos.f_82480_, (double)f1);
            }
            super.m_7023_(pos);
        }
    }

    @Override
    public void m_8119_() {
        LivingEntity passenger;
        if (this.useticks != 0 && --this.useticks <= 0) {
            this.state = State.RELOADING;
            this.useticks = 0;
            this.delayticks = (Integer)this.f_19847_.specs.delaytime.get();
        }
        if (this.hittingticks != 0 && --this.hittingticks <= 0) {
            this.useRelease();
            this.hittingticks = 0;
        }
        if (!this.m_9236_().m_5776_() && this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
        }
        if (this.delayticks > 0 && this.m_20160_()) {
            --this.delayticks;
        }
        if (this.renderupdateticks-- <= 0) {
            this.updateMachineRender();
            this.renderupdateticks = 20;
        }
        if (this.m_9236_().m_5776_() && this.m_217005_() && this.getWheelsSpeed() > 0.0081 && this.wheelssoundticks-- <= 0 && Minecraft.m_91087_().f_91074_ == (passenger = this.m_6688_())) {
            Vec3 pos = this.m_20182_();
            this.m_9236_().m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)SoundTypes.RAM_WHEELS.get(), this.m_5720_(), 1.5f, 0.85f + this.m_9236_().f_46441_.m_188501_() * 0.3f, false);
            this.wheelssoundticks = 20;
        }
        super.m_8119_();
    }

    @Override
    public void use(LivingEntity entity) {
        if (this.deploymentticks > 0 && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_213846_((Component)Component.m_237110_((String)"siegemachines.wait", (Object[])new Object[]{Float.valueOf((float)this.deploymentticks / 20.0f)}).m_130940_(ChatFormatting.RED));
            return;
        }
        if (!this.m_9236_().m_5776_()) {
            PacketHandler.sendPacketToAllInArea(new PacketMachineUse(this.m_19879_()), this.m_20183_(), 16384);
        }
        if (this.delayticks <= 0 && this.useticks <= 0 && this.hittingticks <= 0) {
            this.state = State.HITTING;
            this.useticks = this.f_19847_.usetime;
            this.hittingticks = this.f_19847_.usereleasetime;
            Vec3 pos = this.m_20182_();
            this.m_9236_().m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)SoundTypes.RAM_HITTING.get(), this.m_5720_(), 0.5f, 0.9f, false);
        }
    }

    @Override
    public Useable.UsageType getUsage() {
        return Useable.UsageType.RAM;
    }

    public void ramHit(BlockPos blockpos) {
        if (!this.m_9236_().m_5776_()) {
            Breakdown breakdown = new Breakdown(this.m_9236_(), (Entity)this, (Entity)this.m_6688_(), blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_(), 2.0f, false, 3.0f, Explosion.BlockInteraction.DESTROY);
            breakdown.explode();
            breakdown.finalizeExplosion(true);
        }
    }

    @Override
    public void useRelease() {
        if (this.deploymentticks > 0) {
            return;
        }
        if (!this.m_9236_().m_5776_()) {
            PacketHandler.sendPacketToAllInArea(new PacketMachineUseRelease(this.m_19879_()), this.m_20183_(), 16384);
            BlockPos blockpos = new BlockPos((int)this.getHitPos().f_82479_, (int)this.getHitPos().f_82480_, (int)this.getHitPos().f_82481_);
            this.ramHit(blockpos);
        }
    }

    public double getWheelsSpeed() {
        if (this.m_20096_()) {
            return this.m_20252_(5.0f).m_82542_(1.0, 0.0, 1.0).m_82526_(this.m_20184_());
        }
        return 0.0;
    }

    public void m_5997_(double p_70024_1_, double p_70024_3_, double p_70024_5_) {
    }

    @Override
    public Item getMachineItem() {
        return (Item)ModItems.BATTERING_RAM.get();
    }

    protected Vec3 getHitPos() {
        double pitch = (double)this.getTurretPitch() * Math.PI / 180.0;
        double yaw = (double)(this.m_5675_(0.5f) + this.getTurretYaw()) * Math.PI / 180.0;
        return this.m_20182_().m_82549_(CartesianGeometry.applyRotations(this.f_19847_.turretpivot, 0.0, yaw).m_82549_(CartesianGeometry.applyRotations(this.f_19847_.turretvector, pitch, yaw)));
    }

    public static enum State {
        HITTING,
        RELOADING;

    }
}

