/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.machine;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import ru.magistu.siegemachines.api.enitity.Useable;
import ru.magistu.siegemachines.entity.machine.LadderSeat;
import ru.magistu.siegemachines.entity.machine.Machine;
import ru.magistu.siegemachines.entity.machine.MachineType;
import ru.magistu.siegemachines.item.ModItems;
import ru.magistu.siegemachines.util.CartesianGeometry;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SiegeLadder
extends Machine
implements GeoAnimatable {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final Vec3 CLIMB_VECTOR = new Vec3(0.0, 130.0, 130.0).m_82490_(0.0625);
    private static final Vec3 CLIMB_PIVOT_1 = new Vec3(-8.0, 0.0, -37.0).m_82490_(0.0625);
    private static final Vec3 CLIMB_PIVOT_2 = new Vec3(8.0, 0.0, -37.0).m_82490_(0.0625);
    private static final int NUMBER_OF_SEATS = 16;
    private final List<LadderSeat> leftseats = Stream.generate(() -> new LadderSeat(this)).limit(8L).collect(Collectors.toList());
    private final List<LadderSeat> rightseats = Stream.generate(() -> new LadderSeat(this)).limit(8L).collect(Collectors.toList());
    public final List<LadderSeat> seats = Stream.of(this.leftseats, this.rightseats).flatMap(Collection::stream).collect(Collectors.toList());
    static RawAnimation MOVING_ANIM = RawAnimation.begin().thenLoop("Moving");
    private int wheelssoundticks = 10;
    private double wheelspitch = 0.0;
    private double wheelsspeed = 0.0;

    public SiegeLadder(EntityType<? extends Mob> entitytype, Level level) {
        super(entitytype, level, MachineType.SIEGE_LADDER);
    }

    private PlayState wheels_predicate(AnimationState<SiegeLadder> event) {
        event.getController().setAnimation(MOVING_ANIM);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController wheels_controller = new AnimationController((GeoAnimatable)this, "wheels_controller", 1, this::wheels_predicate).setOverrideEasingType(dbl -> t -> {
            double d = this.getWheelsSpeed();
            this.wheelsspeed = d > 0.0 ? Math.min(d, 1.0) : Math.max(d, -1.0);
            return this.wheelspitch += 0.015 * this.wheelsspeed;
        });
        data.add(new AnimationController[]{wheels_controller});
    }

    public double getTick(Object entity) {
        return this.f_19797_;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_9236_().m_5776_() || player.m_20159_()) {
            return InteractionResult.PASS;
        }
        if (!this.m_20160_()) {
            player.m_20329_((Entity)this);
            return InteractionResult.SUCCESS;
        }
        LadderSeat seat = this.getFreeSeat((Entity)player);
        if (seat != null) {
            player.m_20329_((Entity)seat);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_7023_(Vec3 pos) {
        if (this.m_6084_()) {
            if (this.m_20160_()) {
                LivingEntity livingentity = this.m_6688_();
                this.setYawDest(livingentity.m_146908_());
                this.updateYaw();
                float f1 = livingentity.f_20902_;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                this.m_7910_(0.04f);
                pos = new Vec3(0.0, pos.f_82480_, (double)f1);
            }
            super.m_7023_(pos);
        }
    }

    @Override
    public void m_8119_() {
        if (this.renderupdateticks-- <= 0) {
            this.updateMachineRender();
            this.renderupdateticks = 20;
        }
        this.seatsTick();
        super.m_8119_();
    }

    public void seatsTick() {
        this.leftseats.forEach(seat -> this.updateSeatPosition((LadderSeat)((Object)seat), true));
        this.rightseats.forEach(seat -> this.updateSeatPosition((LadderSeat)((Object)seat), false));
    }

    public void updateSeatPosition(LadderSeat seat, boolean left) {
        double yaw = (double)this.m_146908_() * Math.PI / 180.0;
        float highness = seat.climb();
        Vec3 pos = this.getSeatPosititon(highness, yaw, left);
        Optional freepos = this.m_9236_().m_151418_((Entity)seat, Shapes.m_83064_((AABB)AABB.m_165882_((Vec3)pos, (double)0.1, (double)0.1, (double)0.1)), pos, 0.0, 0.0, 0.0);
        if (freepos.isPresent() && pos.m_82554_((Vec3)freepos.get()) < 0.5) {
            seat.setHighness(highness);
            pos = (Vec3)freepos.get();
        } else {
            pos = this.getSeatPosititon(seat, yaw, left);
        }
        seat.m_20219_(pos);
    }

    public void onRemovedFromWorld() {
        for (LadderSeat seat : this.seats) {
            seat.m_146870_();
        }
        super.onRemovedFromWorld();
    }

    public void onAddedToWorld() {
        this.seats.forEach(seat -> this.m_9236_().m_7967_((Entity)seat));
        super.onAddedToWorld();
    }

    @Override
    public void useRelease() {
    }

    public double getWheelsSpeed() {
        if (this.m_20096_()) {
            return this.m_20252_(5.0f).m_82542_(1.0, 0.0, 1.0).m_82526_(this.m_20184_());
        }
        return 0.0;
    }

    @Override
    public Item getMachineItem() {
        return (Item)ModItems.SIEGE_LADDER.get();
    }

    protected Vec3 getSeatPosititon(LadderSeat seat, double yaw, boolean left) {
        return this.getSeatPosititon(seat.getHighness(), yaw, left);
    }

    protected Vec3 getSeatPosititon(float highness, double yaw, boolean left) {
        return this.m_20182_().m_82549_(CartesianGeometry.applyRotations((left ? CLIMB_PIVOT_1 : CLIMB_PIVOT_2).m_82549_(CLIMB_VECTOR.m_82490_((double)highness)), 0.0, yaw));
    }

    @Nullable
    protected LadderSeat getFreeSeat(Entity entity) {
        long l2;
        AtomicReference<Object> left = new AtomicReference<Object>(null);
        AtomicReference<Object> right = new AtomicReference<Object>(null);
        long l1 = this.leftseats.stream().filter(seat -> {
            if (seat.m_20160_()) {
                return true;
            }
            left.set(seat);
            return false;
        }).count();
        if (l1 < (l2 = this.rightseats.stream().filter(seat -> {
            if (seat.m_20160_()) {
                return true;
            }
            right.set(seat);
            return false;
        }).count())) {
            return left.get();
        }
        if (l1 == l2 && entity != null) {
            Vec3 view = this.m_20252_(0.0f);
            return entity.m_20182_().m_82546_(this.m_20182_()).m_82526_(new Vec3(view.f_82481_, 0.0, -view.f_82479_).m_82541_()) > 0.0 ? (LadderSeat)right.get() : (LadderSeat)left.get();
        }
        return right.get();
    }

    public void m_7334_(Entity entity) {
    }

    public void m_5997_(double x, double y, double z) {
    }

    @Override
    public Useable.UsageType getUsage() {
        return Useable.UsageType.CLIMB;
    }

    @Override
    public void use(@Nullable LivingEntity entity) {
        LadderSeat seat;
        if (this.m_6688_() == entity && (seat = this.getFreeSeat((Entity)entity)) != null) {
            entity.m_20329_((Entity)seat);
        }
    }
}

