/*
 * Decompiled with CFR 0.152.
 */
package net.mosquito.mosquievent;

import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.mosquito.mosquievent.block.ModBlocks;
import net.mosquito.mosquievent.entity.ModEntities;
import net.mosquito.mosquievent.entity.client.BlahajRenderer;
import net.mosquito.mosquievent.entity.client.ChickenbossRenderer;
import net.mosquito.mosquievent.entity.client.DuckRenderer;
import net.mosquito.mosquievent.entity.client.QuokkaRenderer;
import net.mosquito.mosquievent.entity.custom.BlahajEntity;
import net.mosquito.mosquievent.entity.custom.ChickenBossEntity;
import net.mosquito.mosquievent.entity.custom.DuckEntity;
import net.mosquito.mosquievent.entity.custom.QuokkaEntity;
import net.mosquito.mosquievent.item.ModCreativeModTabs;
import net.mosquito.mosquievent.item.ModItems;
import net.mosquito.mosquievent.particle.ModParticles;
import net.mosquito.mosquievent.particle.pink_flame;
import net.mosquito.mosquievent.sound.ModSounds;
import org.slf4j.Logger;
import software.bernie.geckolib.GeckoLib;

@Mod(value="mosquievent")
public class MosquiEvent {
    public static final String MOD_ID = "mosquievent";
    private static final Logger LOGGER = LogUtils.getLogger();

    public MosquiEvent(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModParticles.register(modEventBus);
        ModCreativeModTabs.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModItems.register(modEventBus);
        ModEntities.register(modEventBus);
        ModSounds.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        GeckoLib.initialize();
        modEventBus.addListener(this::addCreative);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @Mod.EventBusSubscriber(modid="mosquievent", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEventBusEvents {
        @SubscribeEvent
        public static void registerAttributes(EntityAttributeCreationEvent event) {
            event.put((EntityType)ModEntities.QUOKKA.get(), QuokkaEntity.setAttributes());
            event.put((EntityType)ModEntities.BLAHAJ.get(), BlahajEntity.setAttributes());
            event.put((EntityType)ModEntities.DUCK.get(), DuckEntity.setAttributes());
            event.put((EntityType)ModEntities.CHICKEN_BOSS.get(), ChickenBossEntity.setAttributes());
        }

        @SubscribeEvent
        public static void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
            event.register((EntityType)ModEntities.QUOKKA.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
            SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntities.BLAHAJ.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BlahajEntity::checkBlahajSpawn);
            event.register((EntityType)ModEntities.DUCK.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        }
    }

    @Mod.EventBusSubscriber(modid="mosquievent", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.BULLET_PROJETILE.get()), ThrownItemRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.POOP_PROJECTILE.get()), ThrownItemRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.QUOKKA.get()), QuokkaRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.BLAHAJ.get()), BlahajRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.DUCK.get()), DuckRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.THROWN_DUCK_EGG.get()), ThrownItemRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.CHICKEN_BOSS.get()), ChickenbossRenderer::new);
        }

        @SubscribeEvent
        public static void registerParticleProvider(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)ModParticles.PINK_FLAME_PARTICLE.get(), pink_flame.Provider::new);
        }
    }
}

